# -*- coding: utf-8 -*-
# chuk_artifacts/providers/ibm_cos.py
"""
Factory for an aioboto3 client wired for IBM Cloud Object Storage (COS).

AUTO-GENERATED by IBM COS Signature Tester
Best configuration: Signature v2 + Virtual (IBM COS Alt)
Score: 10/10
Tested on: 2025-06-20 16:03:24
"""

from __future__ import annotations
import os
import aioboto3
from aioboto3.session import AioConfig
from typing import Optional, Callable, AsyncContextManager


def factory(
    *,
    endpoint_url: Optional[str] = None,
    region: str = "us-south",
    access_key: Optional[str] = None,
    secret_key: Optional[str] = None,
) -> Callable[[], AsyncContextManager]:
    """
    Return an async-context S3 client for IBM COS (HMAC only).

    Tested configuration: Signature v2 + Virtual (IBM COS Alt)
    """
    endpoint_url = endpoint_url or os.getenv(
        "IBM_COS_ENDPOINT",
        "https://s3.us-south.cloud-object-storage.appdomain.cloud",
    )
    access_key = access_key or os.getenv("AWS_ACCESS_KEY_ID")
    secret_key = secret_key or os.getenv("AWS_SECRET_ACCESS_KEY")

    # Extract region from endpoint
    if endpoint_url:
        if "us-south" in endpoint_url:
            region = "us-south"
        elif "us-east" in endpoint_url:
            region = "us-east"
        elif "eu-gb" in endpoint_url:
            region = "eu-gb"
        elif "eu-de" in endpoint_url:
            region = "eu-de"
        elif "jp-tok" in endpoint_url:
            region = "jp-tok"
        elif "au-syd" in endpoint_url:
            region = "au-syd"

    env_region = os.getenv("AWS_REGION")
    if env_region:
        region = env_region

    if not (access_key and secret_key):
        raise RuntimeError(
            "HMAC credentials missing. "
            "Set AWS_ACCESS_KEY_ID / AWS_SECRET_ACCESS_KEY "
            "or generate an HMAC key for your COS instance."
        )

    def _make() -> AsyncContextManager:
        session = aioboto3.Session()
        return session.client(
            "s3",
            endpoint_url=endpoint_url,
            region_name=region,
            aws_access_key_id=access_key,
            aws_secret_access_key=secret_key,
            config=AioConfig(
                signature_version="s3",
                s3={"addressing_style": "virtual"},
                read_timeout=60,
                connect_timeout=30,
                retries={"max_attempts": 3, "mode": "adaptive"},
            ),
        )

    return _make


def client(
    *,
    endpoint_url: Optional[str] = None,
    region: Optional[str] = None,
    access_key: Optional[str] = None,
    secret_key: Optional[str] = None,
):
    """Return an aioboto3 S3 client context manager for IBM COS."""
    session = aioboto3.Session()

    endpoint_url = endpoint_url or os.getenv(
        "IBM_COS_ENDPOINT", "https://s3.us-south.cloud-object-storage.appdomain.cloud"
    )

    if not region:
        if "us-south" in endpoint_url:
            region = "us-south"
        elif "us-east" in endpoint_url:
            region = "us-east"
        elif "eu-gb" in endpoint_url:
            region = "eu-gb"
        else:
            region = "us-south"

    return session.client(
        "s3",
        endpoint_url=endpoint_url,
        region_name=region,
        aws_access_key_id=access_key or os.getenv("AWS_ACCESS_KEY_ID"),
        aws_secret_access_key=secret_key or os.getenv("AWS_SECRET_ACCESS_KEY"),
        config=AioConfig(
            signature_version="s3",
            s3={"addressing_style": "virtual"},
            read_timeout=60,
            connect_timeout=30,
        ),
    )
