"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Discovery = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [discovery](https://docs.aws.amazon.com/service-authorization/latest/reference/list_applicationdiscovery.html).
 *
 * @experimental
 */
class Discovery extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [discovery](https://docs.aws.amazon.com/service-authorization/latest/reference/list_applicationdiscovery.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'discovery';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AssociateConfigurationItemsToApplication",
                "BatchDeleteImportData",
                "CreateApplication",
                "DeleteApplications",
                "DisassociateConfigurationItemsFromApplication",
                "ExportConfigurations",
                "StartContinuousExport",
                "StartDataCollectionByAgentIds",
                "StartExportTask",
                "StartImportTask",
                "StopContinuousExport",
                "StopDataCollectionByAgentIds",
                "UpdateApplication"
            ],
            "Tagging": [
                "CreateTags",
                "DeleteTags"
            ],
            "Read": [
                "DescribeAgents",
                "DescribeConfigurations",
                "DescribeContinuousExports",
                "DescribeExportConfigurations",
                "DescribeExportTasks",
                "DescribeTags",
                "GetDiscoverySummary"
            ],
            "List": [
                "DescribeImportTasks",
                "ListConfigurations",
                "ListServerNeighbors"
            ]
        };
    }
    /**
     * (experimental) Associates one or more configuration items with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html
     *
     * @experimental
     */
    toAssociateConfigurationItemsToApplication() {
        this.to('discovery:AssociateConfigurationItemsToApplication');
        return this;
    }
    /**
     * (experimental) Deletes one or more Migration Hub import tasks, each identified by their import ID.
     *
     * Each import task has a number of records, which can identify servers or applications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html
     *
     * @experimental
     */
    toBatchDeleteImportData() {
        this.to('discovery:BatchDeleteImportData');
        return this;
    }
    /**
     * (experimental) Creates an application with the given name and description.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html
     *
     * @experimental
     */
    toCreateApplication() {
        this.to('discovery:CreateApplication');
        return this;
    }
    /**
     * (experimental) Creates one or more tags for configuration items.
     *
     * Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html
     *
     * @experimental
     */
    toCreateTags() {
        this.to('discovery:CreateTags');
        return this;
    }
    /**
     * (experimental) Deletes a list of applications and their associations with configuration items.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html
     *
     * @experimental
     */
    toDeleteApplications() {
        this.to('discovery:DeleteApplications');
        return this;
    }
    /**
     * (experimental) Deletes the association between configuration items and one or more tags.
     *
     * This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html
     *
     * @experimental
     */
    toDeleteTags() {
        this.to('discovery:DeleteTags');
        return this;
    }
    /**
     * (experimental) Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html
     *
     * @experimental
     */
    toDescribeAgents() {
        this.to('discovery:DescribeAgents');
        return this;
    }
    /**
     * (experimental) Retrieves attributes for a list of configuration item IDs.
     *
     * All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html
     *
     * @experimental
     */
    toDescribeConfigurations() {
        this.to('discovery:DescribeConfigurations');
        return this;
    }
    /**
     * (experimental) Lists exports as specified by ID.
     *
     * All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html
     *
     * @experimental
     */
    toDescribeContinuousExports() {
        this.to('discovery:DescribeContinuousExports');
        return this;
    }
    /**
     * (experimental) Retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html
     *
     * @experimental
     */
    toDescribeExportConfigurations() {
        this.to('discovery:DescribeExportConfigurations');
        return this;
    }
    /**
     * (experimental) Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html
     *
     * @experimental
     */
    toDescribeExportTasks() {
        this.to('discovery:DescribeExportTasks');
        return this;
    }
    /**
     * (experimental) Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html
     *
     * @experimental
     */
    toDescribeImportTasks() {
        this.to('discovery:DescribeImportTasks');
        return this;
    }
    /**
     * (experimental) Retrieves a list of configuration items that are tagged with a specific tag.
     *
     * Or retrieves a list of all tags assigned to a specific configuration item.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html
     *
     * @experimental
     */
    toDescribeTags() {
        this.to('discovery:DescribeTags');
        return this;
    }
    /**
     * (experimental) Disassociates one or more configuration items from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html
     *
     * @experimental
     */
    toDisassociateConfigurationItemsFromApplication() {
        this.to('discovery:DisassociateConfigurationItemsFromApplication');
        return this;
    }
    /**
     * (experimental) Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data.
     *
     * Data includes tags and tag associations, processes, connections, servers, and system performance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html
     *
     * @experimental
     */
    toExportConfigurations() {
        this.to('discovery:ExportConfigurations');
        return this;
    }
    /**
     * (experimental) Retrieves a short summary of discovered assets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html
     *
     * @experimental
     */
    toGetDiscoverySummary() {
        this.to('discovery:GetDiscoverySummary');
        return this;
    }
    /**
     * (experimental) Retrieves a list of configuration items according to criteria you specify in a filter.
     *
     * The filter criteria identify relationship requirements.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html
     *
     * @experimental
     */
    toListConfigurations() {
        this.to('discovery:ListConfigurations');
        return this;
    }
    /**
     * (experimental) Retrieves a list of servers which are one network hop away from a specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html
     *
     * @experimental
     */
    toListServerNeighbors() {
        this.to('discovery:ListServerNeighbors');
        return this;
    }
    /**
     * (experimental) Start the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html
     *
     * @experimental
     */
    toStartContinuousExport() {
        this.to('discovery:StartContinuousExport');
        return this;
    }
    /**
     * (experimental) Instructs the specified agents or Connectors to start collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html
     *
     * @experimental
     */
    toStartDataCollectionByAgentIds() {
        this.to('discovery:StartDataCollectionByAgentIds');
        return this;
    }
    /**
     * (experimental) Export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html
     *
     * @experimental
     */
    toStartExportTask() {
        this.to('discovery:StartExportTask');
        return this;
    }
    /**
     * (experimental) Starts an import task.
     *
     * The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html
     *
     * @experimental
     */
    toStartImportTask() {
        this.to('discovery:StartImportTask');
        return this;
    }
    /**
     * (experimental) Stop the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html
     *
     * @experimental
     */
    toStopContinuousExport() {
        this.to('discovery:StopContinuousExport');
        return this;
    }
    /**
     * (experimental) Instructs the specified agents or Connectors to stop collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html
     *
     * @experimental
     */
    toStopDataCollectionByAgentIds() {
        this.to('discovery:StopDataCollectionByAgentIds');
        return this;
    }
    /**
     * (experimental) Updates metadata about an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html
     *
     * @experimental
     */
    toUpdateApplication() {
        this.to('discovery:UpdateApplication');
        return this;
    }
}
exports.Discovery = Discovery;
//# sourceMappingURL=data:application/json;base64,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