import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [cloudformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudformation.html).
 *
 * @experimental
 */
export declare class Cloudformation extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Cancels an update on the specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html
     *
     * @experimental
     */
    toCancelUpdateStack(): this;
    /**
     * (experimental) For a specified stack that is in the UPDATE_ROLLBACK_FAILED state, continues rolling it back to the UPDATE_ROLLBACK_COMPLETE state.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ContinueUpdateRollback.html
     *
     * @experimental
     */
    toContinueUpdateRollback(): this;
    /**
     * (experimental) Creates a list of changes for a stack.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     * - .ifResourceTypes()
     * - .ifImportResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html
     *
     * @experimental
     */
    toCreateChangeSet(): this;
    /**
     * (experimental) Creates a stack as specified in the template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStack.html
     *
     * @experimental
     */
    toCreateStack(): this;
    /**
     * (experimental) Creates stack instances for the specified accounts, within the specified regions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html
     *
     * @experimental
     */
    toCreateStackInstances(): this;
    /**
     * (experimental) Creates a stackset as specified in the template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackSet.html
     *
     * @experimental
     */
    toCreateStackSet(): this;
    /**
     * (experimental) Access Level: Write.
     *
     * @experimental
     */
    toCreateUploadBucket(): this;
    /**
     * (experimental) Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteChangeSet.html
     *
     * @experimental
     */
    toDeleteChangeSet(): this;
    /**
     * (experimental) Deletes a specified stack.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStack.html
     *
     * @experimental
     */
    toDeleteStack(): this;
    /**
     * (experimental) Deletes stack instances for the specified accounts, in the specified regions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStackInstances.html
     *
     * @experimental
     */
    toDeleteStackInstances(): this;
    /**
     * (experimental) Deletes a specified stackset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStackSet.html
     *
     * @experimental
     */
    toDeleteStackSet(): this;
    /**
     * (experimental) Deregisters an existing CloudFormation type or type version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html
     *
     * @experimental
     */
    toDeregisterType(): this;
    /**
     * (experimental) Retrieves your account's AWS CloudFormation limits.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeAccountLimits.html
     *
     * @experimental
     */
    toDescribeAccountLimits(): this;
    /**
     * (experimental) Returns the description for the specified change set.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeChangeSet.html
     *
     * @experimental
     */
    toDescribeChangeSet(): this;
    /**
     * (experimental) Returns information about a stack drift detection operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackDriftDetectionStatus.html
     *
     * @experimental
     */
    toDescribeStackDriftDetectionStatus(): this;
    /**
     * (experimental) Returns all stack related events for a specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackEvents.html
     *
     * @experimental
     */
    toDescribeStackEvents(): this;
    /**
     * (experimental) Returns the stack instance that's associated with the specified stack set, AWS account, and region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackInstance.html
     *
     * @experimental
     */
    toDescribeStackInstance(): this;
    /**
     * (experimental) Returns a description of the specified resource in the specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResource.html
     *
     * @experimental
     */
    toDescribeStackResource(): this;
    /**
     * (experimental) Returns drift information for the resources that have been checked for drift in the specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResourceDrifts.html
     *
     * @experimental
     */
    toDescribeStackResourceDrifts(): this;
    /**
     * (experimental) Returns AWS resource descriptions for running and deleted stacks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResources.html
     *
     * @experimental
     */
    toDescribeStackResources(): this;
    /**
     * (experimental) Returns the description of the specified stack set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackSet.html
     *
     * @experimental
     */
    toDescribeStackSet(): this;
    /**
     * (experimental) Returns the description of the specified stack set operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackSetOperation.html
     *
     * @experimental
     */
    toDescribeStackSetOperation(): this;
    /**
     * (experimental) Returns the description for the specified stack.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStacks.html
     *
     * @experimental
     */
    toDescribeStacks(): this;
    /**
     * (experimental) Returns information about the CloudFormation type requested.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html
     *
     * @experimental
     */
    toDescribeType(): this;
    /**
     * (experimental) Returns information about the registration process for a CloudFormation type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeTypeRegistration.html
     *
     * @experimental
     */
    toDescribeTypeRegistration(): this;
    /**
     * (experimental) Detects whether a stack's actual configuration differs, or has drifted, from it's expected configuration, as defined in the stack template and any values specified as template parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackDrift.html
     *
     * @experimental
     */
    toDetectStackDrift(): this;
    /**
     * (experimental) Returns information about whether a resource's actual configuration differs, or has drifted, from it's expected configuration, as defined in the stack template and any values specified as template parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackResourceDrift.html
     *
     * @experimental
     */
    toDetectStackResourceDrift(): this;
    /**
     * (experimental) Enables users to detect drift on a stack set and the stack instances that belong to that stack set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackSetDrift.html
     *
     * @experimental
     */
    toDetectStackSetDrift(): this;
    /**
     * (experimental) Returns the estimated monthly cost of a template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_EstimateTemplateCost.html
     *
     * @experimental
     */
    toEstimateTemplateCost(): this;
    /**
     * (experimental) Updates a stack using the input information that was provided when the specified change set was created.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html
     *
     * @experimental
     */
    toExecuteChangeSet(): this;
    /**
     * (experimental) Returns the stack policy for a specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetStackPolicy.html
     *
     * @experimental
     */
    toGetStackPolicy(): this;
    /**
     * (experimental) Returns the template body for a specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetTemplate.html
     *
     * @experimental
     */
    toGetTemplate(): this;
    /**
     * (experimental) Returns information about a new or existing template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetTemplateSummary.html
     *
     * @experimental
     */
    toGetTemplateSummary(): this;
    /**
     * (experimental) Returns the ID and status of each active change set for a stack.
     *
     * For example, AWS CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or CREATE_PENDING state.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListChangeSets.html
     *
     * @experimental
     */
    toListChangeSets(): this;
    /**
     * (experimental) Lists all exported output values in the account and region in which you call this action.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListExports.html
     *
     * @experimental
     */
    toListExports(): this;
    /**
     * (experimental) Lists all stacks that are importing an exported output value.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListImports.html
     *
     * @experimental
     */
    toListImports(): this;
    /**
     * (experimental) Returns summary information about stack instances that are associated with the specified stack set.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSets.html
     *
     * @experimental
     */
    toListStackInstances(): this;
    /**
     * (experimental) Returns descriptions of all resources of the specified stack.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackResources.html
     *
     * @experimental
     */
    toListStackResources(): this;
    /**
     * (experimental) Returns summary information about the results of a stack set operation.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetOperationResults.html
     *
     * @experimental
     */
    toListStackSetOperationResults(): this;
    /**
     * (experimental) Returns summary information about operations performed on a stack set.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetOperations.html
     *
     * @experimental
     */
    toListStackSetOperations(): this;
    /**
     * (experimental) Returns summary information about stack sets that are associated with the user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSets.html
     *
     * @experimental
     */
    toListStackSets(): this;
    /**
     * (experimental) Returns the summary information for stacks whose status matches the specified StackStatusFilter.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStacks.html
     *
     * @experimental
     */
    toListStacks(): this;
    /**
     * (experimental) Lists CloudFormation type registration attempts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypeRegistrations.html
     *
     * @experimental
     */
    toListTypeRegistrations(): this;
    /**
     * (experimental) Lists versions of a particular CloudFormation type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypeVersions.html
     *
     * @experimental
     */
    toListTypeVersions(): this;
    /**
     * (experimental) Lists available CloudFormation types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html
     *
     * @experimental
     */
    toListTypes(): this;
    /**
     * (experimental) Registers a new CloudFormation type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html
     *
     * @experimental
     */
    toRegisterType(): this;
    /**
     * (experimental) Sets a stack policy for a specified stack.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifStackPolicyUrl()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetStackPolicy.html
     *
     * @experimental
     */
    toSetStackPolicy(): this;
    /**
     * (experimental) Sets which version of a CloudFormation type applies to CloudFormation operations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeDefaultVersion.html
     *
     * @experimental
     */
    toSetTypeDefaultVersion(): this;
    /**
     * (experimental) Sends a signal to the specified resource with a success or failure status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SignalResource.html
     *
     * @experimental
     */
    toSignalResource(): this;
    /**
     * (experimental) Stops an in-progress operation on a stack set and its associated stack instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StopStackSetOperation.html
     *
     * @experimental
     */
    toStopStackSetOperation(): this;
    /**
     * (experimental) Tagging cloudformation resources.
     *
     * Access Level: Tagging
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Untagging cloudformation resources.
     *
     * Access Level: Tagging
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Updates a stack as specified in the template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStack.html
     *
     * @experimental
     */
    toUpdateStack(): this;
    /**
     * (experimental) Updates the parameter values for stack instances for the specified accounts, within the specified regions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackInstances.html
     *
     * @experimental
     */
    toUpdateStackInstances(): this;
    /**
     * (experimental) Updates a stackset as specified in the template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html
     *
     * @experimental
     */
    toUpdateStackSet(): this;
    /**
     * (experimental) Updates termination protection for the specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateTerminationProtection.html
     *
     * @experimental
     */
    toUpdateTerminationProtection(): this;
    /**
     * (experimental) Validates a specified template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ValidateTemplate.html
     *
     * @experimental
     */
    toValidateTemplate(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type stack to the statement.
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-concepts.html#w2ab1b5c15b9
     *
     * @param stackName - Identifier for the stackName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStack(stackName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type stackset to the statement.
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stacksets-concepts-stackset
     *
     * @param stackSetName - Identifier for the stackSetName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStackset(stackSetName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type changeset to the statement.
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-concepts.html#w2ab1b5c15c11
     *
     * @param changeSetName - Identifier for the changeSetName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onChangeset(changeSetName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) An AWS CloudFormation change set name. Use to control which change sets IAM users can execute or delete.
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toDeleteChangeSet()
     * - .toDescribeChangeSet()
     * - .toExecuteChangeSet()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifChangeSetName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The template resource types, such as `AWS::EC2::Instance`.
     *
     * Use to control which resource types IAM users can work with when they want to import a resource into a stack.
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifImportResourceTypes(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The template resource types, such as `AWS::EC2::Instance`.
     *
     * Use to control which resource types IAM users can work with when they create or update a stack.
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toUpdateStack()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTypes(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The ARN of an IAM service role.
     *
     * Use to control which service role IAM users can use to work with stacks or change sets.
     *
     * Applies to actions:
     * - .toContinueUpdateRollback()
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toCreateStackSet()
     * - .toDeleteStack()
     * - .toUpdateStack()
     * - .toUpdateStackSet()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifRoleArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) An Amazon S3 stack policy URL.
     *
     * Use to control which stack policies IAM users can associate with a stack during a create or update stack action.
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toSetStackPolicy()
     * - .toUpdateStack()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifStackPolicyUrl(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) An Amazon S3 template URL.
     *
     * Use to control which templates IAM users can use when they create or update stacks.
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toCreateStackSet()
     * - .toUpdateStack()
     * - .toUpdateStackSet()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTemplateUrl(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [cloudformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudformation.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
