import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_computeoptimizer.html).
 *
 * @experimental
 */
export declare class ComputeOptimizer extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to view the status of recommendation export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html
     *
     * @experimental
     */
    toDescribeRecommendationExportJobs(): this;
    /**
     * (experimental) Grants permission to export autoscaling group recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html
     *
     * @experimental
     */
    toExportAutoScalingGroupRecommendations(): this;
    /**
     * (experimental) Grants permission to export EC2 instance recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html
     *
     * @experimental
     */
    toExportEC2InstanceRecommendations(): this;
    /**
     * (experimental) Grants permission to get recommendations for the provided autoscaling groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html
     *
     * @experimental
     */
    toGetAutoScalingGroupRecommendations(): this;
    /**
     * (experimental) Grants permission to get recommendations for the provided EC2 instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html
     *
     * @experimental
     */
    toGetEC2InstanceRecommendations(): this;
    /**
     * (experimental) Grants permission to get the recommendation projected metrics of the specified instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html
     *
     * @experimental
     */
    toGetEC2RecommendationProjectedMetrics(): this;
    /**
     * (experimental) Grants permission to get the enrollment status for the specified account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html
     *
     * @experimental
     */
    toGetEnrollmentStatus(): this;
    /**
     * (experimental) Grants permission to get the recommendation summaries for the specified account(s).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html
     *
     * @experimental
     */
    toGetRecommendationSummaries(): this;
    /**
     * (experimental) Grants permission to update the enrollment status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html
     *
     * @experimental
     */
    toUpdateEnrollmentStatus(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_computeoptimizer.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
