import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [ce](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostexplorerservice.html).
 *
 * @experimental
 */
export declare class Ce extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create a new Anomaly Monitor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CreateAnomalyMonitor.html
     *
     * @experimental
     */
    toCreateAnomalyMonitor(): this;
    /**
     * (experimental) Grants permission to create a new Anomaly Subscription.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CreateAnomalySubscription.html
     *
     * @experimental
     */
    toCreateAnomalySubscription(): this;
    /**
     * (experimental) Grants permission to create a new Cost Category with the requested name and rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CreateCostCategoryDefinition.html
     *
     * @experimental
     */
    toCreateCostCategoryDefinition(): this;
    /**
     * (experimental) Grants permission to create Reservation expiration alerts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toCreateNotificationSubscription(): this;
    /**
     * (experimental) Grants permission to create Cost Explorer Reports.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toCreateReport(): this;
    /**
     * (experimental) Grants permission to delete an Anomaly Monitor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DeleteAnomalyMonitor.html
     *
     * @experimental
     */
    toDeleteAnomalyMonitor(): this;
    /**
     * (experimental) Grants permission to delete an Anomaly Subscription.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DeleteAnomalySubscription.html
     *
     * @experimental
     */
    toDeleteAnomalySubscription(): this;
    /**
     * (experimental) Grants permission to delete a Cost Category.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DeleteCostCategoryDefinition.html
     *
     * @experimental
     */
    toDeleteCostCategoryDefinition(): this;
    /**
     * (experimental) Grants permission to delete Reservation expiration alerts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toDeleteNotificationSubscription(): this;
    /**
     * (experimental) Grants permission to delete Cost Explorer Reports.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toDeleteReport(): this;
    /**
     * (experimental) Grants permission to retrieve descriptions such as the name, ARN, rules, definition, and effective dates of a Cost Category.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DescribeCostCategoryDefinition.html
     *
     * @experimental
     */
    toDescribeCostCategoryDefinition(): this;
    /**
     * (experimental) Grants permission to view Reservation expiration alerts.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toDescribeNotificationSubscription(): this;
    /**
     * (experimental) Grants permission to view Cost Explorer Reports page.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toDescribeReport(): this;
    /**
     * (experimental) Grants permission to retrieve anomalies.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetAnomalies.html
     *
     * @experimental
     */
    toGetAnomalies(): this;
    /**
     * (experimental) Grants permission to query Anomaly Monitors.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetAnomalyMonitors.html
     *
     * @experimental
     */
    toGetAnomalyMonitors(): this;
    /**
     * (experimental) Grants permission to query Anomaly Subscriptions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetAnomalySubscriptions.html
     *
     * @experimental
     */
    toGetAnomalySubscriptions(): this;
    /**
     * (experimental) Grants permission to retrieve the cost and usage metrics for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostAndUsage.html
     *
     * @experimental
     */
    toGetCostAndUsage(): this;
    /**
     * (experimental) Grants permission to retrieve the cost and usage metrics with resources for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostAndUsageWithResources.html
     *
     * @experimental
     */
    toGetCostAndUsageWithResources(): this;
    /**
     * (experimental) Grants permission to retrieve a cost forecast for a forecast time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostForecast.html
     *
     * @experimental
     */
    toGetCostForecast(): this;
    /**
     * (experimental) Grants permission to retrieve all available filter values for a filter for a period of time.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html
     *
     * @experimental
     */
    toGetDimensionValues(): this;
    /**
     * (experimental) Grants permission to view Cost Explorer Preferences page.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toGetPreferences(): this;
    /**
     * (experimental) Grants permission to retrieve the reservation coverage for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationCoverage.html
     *
     * @experimental
     */
    toGetReservationCoverage(): this;
    /**
     * (experimental) Grants permission to retrieve the reservation recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationPurchaseRecommendation.html
     *
     * @experimental
     */
    toGetReservationPurchaseRecommendation(): this;
    /**
     * (experimental) Grants permission to retrieve the reservation utilization for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationUtilization.html
     *
     * @experimental
     */
    toGetReservationUtilization(): this;
    /**
     * (experimental) Grants permission to retrieve the rightsizing recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetRightsizingRecommendation.html
     *
     * @experimental
     */
    toGetRightsizingRecommendation(): this;
    /**
     * (experimental) Grants permission to retrieve the Savings Plans coverage for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansCoverage.html
     *
     * @experimental
     */
    toGetSavingsPlansCoverage(): this;
    /**
     * (experimental) Grants permission to retrieve the Savings Plans recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansPurchaseRecommendation.html
     *
     * @experimental
     */
    toGetSavingsPlansPurchaseRecommendation(): this;
    /**
     * (experimental) Grants permission to retrieve the Savings Plans utilization for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansUtilization.html
     *
     * @experimental
     */
    toGetSavingsPlansUtilization(): this;
    /**
     * (experimental) Grants permission to retrieve the Savings Plans utilization details for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansUtilizationDetails.html
     *
     * @experimental
     */
    toGetSavingsPlansUtilizationDetails(): this;
    /**
     * (experimental) Grants permission to query tags for a specified time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetTags.html
     *
     * @experimental
     */
    toGetTags(): this;
    /**
     * (experimental) Grants permission to retrieve a usage forecast for a forecast time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetUsageForecast.html
     *
     * @experimental
     */
    toGetUsageForecast(): this;
    /**
     * (experimental) Grants permission to retrieve names, ARN, and effective dates for all Cost Categories.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ListCostCategoryDefinitions.html
     *
     * @experimental
     */
    toListCostCategoryDefinitions(): this;
    /**
     * (experimental) Grants permission to provide feedback on detected anomalies.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ProvideAnomalyFeedback.html
     *
     * @experimental
     */
    toProvideAnomalyFeedback(): this;
    /**
     * (experimental) Grants permission to update an existing Anomaly Monitor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateAnomalyMonitor.html
     *
     * @experimental
     */
    toUpdateAnomalyMonitor(): this;
    /**
     * (experimental) Grants permission to update an existing Anomaly Subscription.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateAnomalySubscription.html
     *
     * @experimental
     */
    toUpdateAnomalySubscription(): this;
    /**
     * (experimental) Grants permission to update an existing Cost Category.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateCostCategoryDefinition.html
     *
     * @experimental
     */
    toUpdateCostCategoryDefinition(): this;
    /**
     * (experimental) Grants permission to update Reservation expiration alerts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toUpdateNotificationSubscription(): this;
    /**
     * (experimental) Grants permission to edit Cost Explorer Preferences page.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toUpdatePreferences(): this;
    /**
     * (experimental) Grants permission to update Cost Explorer Reports.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     *
     * @experimental
     */
    toUpdateReport(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [ce](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostexplorerservice.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
