import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [mediaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediaconnect.html).
 *
 * @experimental
 */
export declare class Mediaconnect extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to add outputs to any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs.html
     *
     * @experimental
     */
    toAddFlowOutputs(): this;
    /**
     * (experimental) Grants permission to create flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     *
     * @experimental
     */
    toCreateFlow(): this;
    /**
     * (experimental) Grants permission to delete flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn.html
     *
     * @experimental
     */
    toDeleteFlow(): this;
    /**
     * (experimental) Grants permission to display the details of a flow including the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn.html
     *
     * @experimental
     */
    toDescribeFlow(): this;
    /**
     * (experimental) Grants permission to grant entitlements on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements.html
     *
     * @experimental
     */
    toGrantFlowEntitlements(): this;
    /**
     * (experimental) Grants permission to display a list of all entitlements that have been granted to the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-entitlements.html
     *
     * @experimental
     */
    toListEntitlements(): this;
    /**
     * (experimental) Grants permission to display a list of flows that are associated with this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows.html
     *
     * @experimental
     */
    toListFlows(): this;
    /**
     * (experimental) Grants permission to remove outputs from any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs-outputarn.html
     *
     * @experimental
     */
    toRemoveFlowOutput(): this;
    /**
     * (experimental) Grants permission to revoke entitlements on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements-entitlementarn.html
     *
     * @experimental
     */
    toRevokeFlowEntitlement(): this;
    /**
     * (experimental) Grants permission to start flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-start-flowarn.html
     *
     * @experimental
     */
    toStartFlow(): this;
    /**
     * (experimental) Grants permission to stop flows.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-stop-flowarn.html
     *
     * @experimental
     */
    toStopFlow(): this;
    /**
     * (experimental) Grants permission to update entitlements on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-entitlements-entitlementarn.html
     *
     * @experimental
     */
    toUpdateFlowEntitlement(): this;
    /**
     * (experimental) Grants permission to update outputs on any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-outputs-outputarn.html
     *
     * @experimental
     */
    toUpdateFlowOutput(): this;
    /**
     * (experimental) Grants permission to update the source of any flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source-sourcearn.html
     *
     * @experimental
     */
    toUpdateFlowSource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Entitlement to the statement.
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/entitlements.html
     *
     * @param flowId - Identifier for the flowId.
     * @param entitlementName - Identifier for the entitlementName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEntitlement(flowId: string, entitlementName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Flow to the statement.
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/flows.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFlow(flowId: string, flowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Output to the statement.
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/outputs.html
     *
     * @param outputId - Identifier for the outputId.
     * @param outputName - Identifier for the outputName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onOutput(outputId: string, outputName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Source to the statement.
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/sources.html
     *
     * @param sourceId - Identifier for the sourceId.
     * @param sourceName - Identifier for the sourceName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSource(sourceId: string, sourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [mediaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediaconnect.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
