import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [forecast](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonforecast.html).
 *
 * @experimental
 */
export declare class Forecast extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Creates a dataset.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_CreateDataset.html
     *
     * @experimental
     */
    toCreateDataset(): this;
    /**
     * (experimental) Creates a dataset group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_CreateDatasetGroup.html
     *
     * @experimental
     */
    toCreateDatasetGroup(): this;
    /**
     * (experimental) Creates a dataset import job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_CreateDatasetImportJob.html
     *
     * @experimental
     */
    toCreateDatasetImportJob(): this;
    /**
     * (experimental) Creates a forecast.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_CreateForecast.html
     *
     * @experimental
     */
    toCreateForecast(): this;
    /**
     * (experimental) Creates a forecast export job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_CreateForecastExportJob.html
     *
     * @experimental
     */
    toCreateForecastExportJob(): this;
    /**
     * (experimental) Creates a predictor.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_CreatePredictor.html
     *
     * @experimental
     */
    toCreatePredictor(): this;
    /**
     * (experimental) Deletes a dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DeleteDataset.html
     *
     * @experimental
     */
    toDeleteDataset(): this;
    /**
     * (experimental) Deletes a dataset group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DeleteDatasetGroup.html
     *
     * @experimental
     */
    toDeleteDatasetGroup(): this;
    /**
     * (experimental) Deletes a dataset import job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DeleteDatasetImportJob.html
     *
     * @experimental
     */
    toDeleteDatasetImportJob(): this;
    /**
     * (experimental) Deletes a forecast.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DeleteForecast.html
     *
     * @experimental
     */
    toDeleteForecast(): this;
    /**
     * (experimental) Deletes a forecast export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DeleteForecastExportJob.html
     *
     * @experimental
     */
    toDeleteForecastExportJob(): this;
    /**
     * (experimental) Deletes a predictor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DeletePredictor.html
     *
     * @experimental
     */
    toDeletePredictor(): this;
    /**
     * (experimental) Describes a dataset.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DescribeDataset.html
     *
     * @experimental
     */
    toDescribeDataset(): this;
    /**
     * (experimental) Describes a dataset group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DescribeDatasetGroup.html
     *
     * @experimental
     */
    toDescribeDatasetGroup(): this;
    /**
     * (experimental) Describes a dataset import job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DescribeDatasetImportJob.html
     *
     * @experimental
     */
    toDescribeDatasetImportJob(): this;
    /**
     * (experimental) Describes a forecast.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DescribeForecast.html
     *
     * @experimental
     */
    toDescribeForecast(): this;
    /**
     * (experimental) Describes a forecast export job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DescribeForecastExportJob.html
     *
     * @experimental
     */
    toDescribeForecastExportJob(): this;
    /**
     * (experimental) Describes a predictor.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_DescribePredictor.html
     *
     * @experimental
     */
    toDescribePredictor(): this;
    /**
     * (experimental) Gets Accuracy Metrics for a predictor.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_GetAccuracyMetrics.html
     *
     * @experimental
     */
    toGetAccuracyMetrics(): this;
    /**
     * (experimental) Lists dataset groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_ListDatasetGroups.html
     *
     * @experimental
     */
    toListDatasetGroups(): this;
    /**
     * (experimental) Lists dataset import jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_ListDatasetImportJobs.html
     *
     * @experimental
     */
    toListDatasetImportJobs(): this;
    /**
     * (experimental) Lists datasets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_ListDatasets.html
     *
     * @experimental
     */
    toListDatasets(): this;
    /**
     * (experimental) Lists forecast export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_ListForecastExportJobs.html
     *
     * @experimental
     */
    toListForecastExportJobs(): this;
    /**
     * (experimental) Lists forecasts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_ListForecasts.html
     *
     * @experimental
     */
    toListForecasts(): this;
    /**
     * (experimental) Lists predictors.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_ListPredictors.html
     *
     * @experimental
     */
    toListPredictors(): this;
    /**
     * (experimental) Lists the tags for an Amazon Forecast resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Retrieves a forecast for a single item.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_forecastquery_QueryForecast.html
     *
     * @experimental
     */
    toQueryForecast(): this;
    /**
     * (experimental) Associates the specified tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Deletes the specified tags for a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Updates a dataset group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/forecast/latest/dg/API_Operations.htmlAPI_UpdateDatasetGroup.html
     *
     * @experimental
     */
    toUpdateDatasetGroup(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type dataset to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDataset(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type datasetGroup to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDatasetGroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type datasetImportJob to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDatasetImportJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type algorithm to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAlgorithm(resourceId: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type predictor to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPredictor(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type forecast to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onForecast(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type forecastExport to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onForecastExport(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [forecast](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonforecast.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
