"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iam = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [iam](https://docs.aws.amazon.com/service-authorization/latest/reference/list_identityandaccessmanagement.html).
 *
 * @experimental
 */
class Iam extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [iam](https://docs.aws.amazon.com/service-authorization/latest/reference/list_identityandaccessmanagement.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'iam';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AddClientIDToOpenIDConnectProvider",
                "AddRoleToInstanceProfile",
                "AddUserToGroup",
                "ChangePassword",
                "CreateAccessKey",
                "CreateAccountAlias",
                "CreateGroup",
                "CreateInstanceProfile",
                "CreateLoginProfile",
                "CreateOpenIDConnectProvider",
                "CreateRole",
                "CreateSAMLProvider",
                "CreateServiceLinkedRole",
                "CreateServiceSpecificCredential",
                "CreateUser",
                "CreateVirtualMFADevice",
                "DeactivateMFADevice",
                "DeleteAccessKey",
                "DeleteAccountAlias",
                "DeleteGroup",
                "DeleteInstanceProfile",
                "DeleteLoginProfile",
                "DeleteOpenIDConnectProvider",
                "DeleteRole",
                "DeleteSAMLProvider",
                "DeleteSSHPublicKey",
                "DeleteServerCertificate",
                "DeleteServiceLinkedRole",
                "DeleteServiceSpecificCredential",
                "DeleteSigningCertificate",
                "DeleteUser",
                "DeleteVirtualMFADevice",
                "EnableMFADevice",
                "PassRole",
                "RemoveClientIDFromOpenIDConnectProvider",
                "RemoveRoleFromInstanceProfile",
                "RemoveUserFromGroup",
                "ResetServiceSpecificCredential",
                "ResyncMFADevice",
                "SetSecurityTokenServicePreferences",
                "UpdateAccessKey",
                "UpdateAccountPasswordPolicy",
                "UpdateGroup",
                "UpdateLoginProfile",
                "UpdateOpenIDConnectProviderThumbprint",
                "UpdateRole",
                "UpdateRoleDescription",
                "UpdateSAMLProvider",
                "UpdateSSHPublicKey",
                "UpdateServerCertificate",
                "UpdateServiceSpecificCredential",
                "UpdateSigningCertificate",
                "UpdateUser",
                "UploadSSHPublicKey",
                "UploadServerCertificate",
                "UploadSigningCertificate"
            ],
            "Permissions management": [
                "AttachGroupPolicy",
                "AttachRolePolicy",
                "AttachUserPolicy",
                "CreatePolicy",
                "CreatePolicyVersion",
                "DeleteAccountPasswordPolicy",
                "DeleteGroupPolicy",
                "DeletePolicy",
                "DeletePolicyVersion",
                "DeleteRolePermissionsBoundary",
                "DeleteRolePolicy",
                "DeleteUserPermissionsBoundary",
                "DeleteUserPolicy",
                "DetachGroupPolicy",
                "DetachRolePolicy",
                "DetachUserPolicy",
                "PutGroupPolicy",
                "PutRolePermissionsBoundary",
                "PutRolePolicy",
                "PutUserPermissionsBoundary",
                "PutUserPolicy",
                "SetDefaultPolicyVersion",
                "UpdateAssumeRolePolicy"
            ],
            "Read": [
                "GenerateCredentialReport",
                "GenerateOrganizationsAccessReport",
                "GenerateServiceLastAccessedDetails",
                "GetAccessKeyLastUsed",
                "GetAccountAuthorizationDetails",
                "GetAccountPasswordPolicy",
                "GetContextKeysForCustomPolicy",
                "GetContextKeysForPrincipalPolicy",
                "GetCredentialReport",
                "GetGroup",
                "GetGroupPolicy",
                "GetInstanceProfile",
                "GetOpenIDConnectProvider",
                "GetOrganizationsAccessReport",
                "GetPolicy",
                "GetPolicyVersion",
                "GetRole",
                "GetRolePolicy",
                "GetSAMLProvider",
                "GetSSHPublicKey",
                "GetServerCertificate",
                "GetServiceLastAccessedDetails",
                "GetServiceLastAccessedDetailsWithEntities",
                "GetServiceLinkedRoleDeletionStatus",
                "GetUser",
                "GetUserPolicy",
                "SimulateCustomPolicy",
                "SimulatePrincipalPolicy"
            ],
            "List": [
                "GetAccountSummary",
                "GetLoginProfile",
                "ListAccessKeys",
                "ListAccountAliases",
                "ListAttachedGroupPolicies",
                "ListAttachedRolePolicies",
                "ListAttachedUserPolicies",
                "ListEntitiesForPolicy",
                "ListGroupPolicies",
                "ListGroups",
                "ListGroupsForUser",
                "ListInstanceProfiles",
                "ListInstanceProfilesForRole",
                "ListMFADevices",
                "ListOpenIDConnectProviders",
                "ListPolicies",
                "ListPoliciesGrantingServiceAccess",
                "ListPolicyVersions",
                "ListRolePolicies",
                "ListRoleTags",
                "ListRoles",
                "ListSAMLProviders",
                "ListSSHPublicKeys",
                "ListServerCertificates",
                "ListServiceSpecificCredentials",
                "ListSigningCertificates",
                "ListUserPolicies",
                "ListUserTags",
                "ListUsers",
                "ListVirtualMFADevices"
            ],
            "Tagging": [
                "TagRole",
                "TagUser",
                "UntagRole",
                "UntagUser"
            ]
        };
    }
    /**
     * (experimental) Grants permission to add a new client ID (audience) to the list of registered IDs for the specified IAM OpenID Connect (OIDC) provider resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddClientIDToOpenIDConnectProvider.html
     *
     * @experimental
     */
    toAddClientIDToOpenIDConnectProvider() {
        this.to('iam:AddClientIDToOpenIDConnectProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to add an IAM role to the specified instance profile.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddRoleToInstanceProfile.html
     *
     * @experimental
     */
    toAddRoleToInstanceProfile() {
        this.to('iam:AddRoleToInstanceProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to add an IAM user to the specified IAM group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddUserToGroup.html
     *
     * @experimental
     */
    toAddUserToGroup() {
        this.to('iam:AddUserToGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to attach a managed policy to the specified IAM group.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachGroupPolicy.html
     *
     * @experimental
     */
    toAttachGroupPolicy() {
        this.to('iam:AttachGroupPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to attach a managed policy to the specified IAM role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html
     *
     * @experimental
     */
    toAttachRolePolicy() {
        this.to('iam:AttachRolePolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to attach a managed policy to the specified IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachUserPolicy.html
     *
     * @experimental
     */
    toAttachUserPolicy() {
        this.to('iam:AttachUserPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission for an IAM user to to change their own password.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ChangePassword.html
     *
     * @experimental
     */
    toChangePassword() {
        this.to('iam:ChangePassword');
        return this;
    }
    /**
     * (experimental) Grants permission to create access key and secret access key for the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateAccessKey.html
     *
     * @experimental
     */
    toCreateAccessKey() {
        this.to('iam:CreateAccessKey');
        return this;
    }
    /**
     * (experimental) Grants permission to create an alias for your AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateAccountAlias.html
     *
     * @experimental
     */
    toCreateAccountAlias() {
        this.to('iam:CreateAccountAlias');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateGroup.html
     *
     * @experimental
     */
    toCreateGroup() {
        this.to('iam:CreateGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateInstanceProfile.html
     *
     * @experimental
     */
    toCreateInstanceProfile() {
        this.to('iam:CreateInstanceProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to create a password for the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateLoginProfile.html
     *
     * @experimental
     */
    toCreateLoginProfile() {
        this.to('iam:CreateLoginProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to create an IAM resource that describes an identity provider (IdP) that supports OpenID Connect (OIDC).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html
     *
     * @experimental
     */
    toCreateOpenIDConnectProvider() {
        this.to('iam:CreateOpenIDConnectProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new managed policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html
     *
     * @experimental
     */
    toCreatePolicy() {
        this.to('iam:CreatePolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new version of the specified managed policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicyVersion.html
     *
     * @experimental
     */
    toCreatePolicyVersion() {
        this.to('iam:CreatePolicyVersion');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new role.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html
     *
     * @experimental
     */
    toCreateRole() {
        this.to('iam:CreateRole');
        return this;
    }
    /**
     * (experimental) Grants permission to create an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateSAMLProvider.html
     *
     * @experimental
     */
    toCreateSAMLProvider() {
        this.to('iam:CreateSAMLProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to create an IAM role that allows an AWS service to perform actions on your behalf.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAWSServiceName()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateServiceLinkedRole.html
     *
     * @experimental
     */
    toCreateServiceLinkedRole() {
        this.to('iam:CreateServiceLinkedRole');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new service-specific credential for an IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateServiceSpecificCredential.html
     *
     * @experimental
     */
    toCreateServiceSpecificCredential() {
        this.to('iam:CreateServiceSpecificCredential');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new IAM user.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateUser.html
     *
     * @experimental
     */
    toCreateUser() {
        this.to('iam:CreateUser');
        return this;
    }
    /**
     * (experimental) Grants permission to create a new virtual MFA device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateVirtualMFADevice.html
     *
     * @experimental
     */
    toCreateVirtualMFADevice() {
        this.to('iam:CreateVirtualMFADevice');
        return this;
    }
    /**
     * (experimental) Grants permission to deactivate the specified MFA device and remove its association with the IAM user for which it was originally enabled.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html
     *
     * @experimental
     */
    toDeactivateMFADevice() {
        this.to('iam:DeactivateMFADevice');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the access key pair that is associated with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccessKey.html
     *
     * @experimental
     */
    toDeleteAccessKey() {
        this.to('iam:DeleteAccessKey');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified AWS account alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccountAlias.html
     *
     * @experimental
     */
    toDeleteAccountAlias() {
        this.to('iam:DeleteAccountAlias');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the password policy for the AWS account.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccountPasswordPolicy.html
     *
     * @experimental
     */
    toDeleteAccountPasswordPolicy() {
        this.to('iam:DeleteAccountPasswordPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified IAM group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteGroup.html
     *
     * @experimental
     */
    toDeleteGroup() {
        this.to('iam:DeleteGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified inline policy from its group.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteGroupPolicy.html
     *
     * @experimental
     */
    toDeleteGroupPolicy() {
        this.to('iam:DeleteGroupPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteInstanceProfile.html
     *
     * @experimental
     */
    toDeleteInstanceProfile() {
        this.to('iam:DeleteInstanceProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the password for the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteLoginProfile.html
     *
     * @experimental
     */
    toDeleteLoginProfile() {
        this.to('iam:DeleteLoginProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to delete an OpenID Connect identity provider (IdP) resource object in IAM.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteOpenIDConnectProvider.html
     *
     * @experimental
     */
    toDeleteOpenIDConnectProvider() {
        this.to('iam:DeleteOpenIDConnectProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified managed policy and remove it from any IAM entities (users, groups, or roles) to which it is attached.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicy.html
     *
     * @experimental
     */
    toDeletePolicy() {
        this.to('iam:DeletePolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a version from the specified managed policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html
     *
     * @experimental
     */
    toDeletePolicyVersion() {
        this.to('iam:DeletePolicyVersion');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified role.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRole.html
     *
     * @experimental
     */
    toDeleteRole() {
        this.to('iam:DeleteRole');
        return this;
    }
    /**
     * (experimental) Grants permission to remove the permissions boundary from a role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePermissionsBoundary.html
     *
     * @experimental
     */
    toDeleteRolePermissionsBoundary() {
        this.to('iam:DeleteRolePermissionsBoundary');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified inline policy from the specified role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePolicy.html
     *
     * @experimental
     */
    toDeleteRolePolicy() {
        this.to('iam:DeleteRolePolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a SAML provider resource in IAM.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSAMLProvider.html
     *
     * @experimental
     */
    toDeleteSAMLProvider() {
        this.to('iam:DeleteSAMLProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified SSH public key.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSSHPublicKey.html
     *
     * @experimental
     */
    toDeleteSSHPublicKey() {
        this.to('iam:DeleteSSHPublicKey');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified server certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServerCertificate.html
     *
     * @experimental
     */
    toDeleteServerCertificate() {
        this.to('iam:DeleteServerCertificate');
        return this;
    }
    /**
     * (experimental) Grants permission to delete an IAM role that is linked to a specific AWS service, if the service is no longer using it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html
     *
     * @experimental
     */
    toDeleteServiceLinkedRole() {
        this.to('iam:DeleteServiceLinkedRole');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified service-specific credential for an IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceSpecificCredential.html
     *
     * @experimental
     */
    toDeleteServiceSpecificCredential() {
        this.to('iam:DeleteServiceSpecificCredential');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a signing certificate that is associated with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSigningCertificate.html
     *
     * @experimental
     */
    toDeleteSigningCertificate() {
        this.to('iam:DeleteSigningCertificate');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUser.html
     *
     * @experimental
     */
    toDeleteUser() {
        this.to('iam:DeleteUser');
        return this;
    }
    /**
     * (experimental) Grants permission to remove the permissions boundary from the specified IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPermissionsBoundary.html
     *
     * @experimental
     */
    toDeleteUserPermissionsBoundary() {
        this.to('iam:DeleteUserPermissionsBoundary');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the specified inline policy from an IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPolicy.html
     *
     * @experimental
     */
    toDeleteUserPolicy() {
        this.to('iam:DeleteUserPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a virtual MFA device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteVirtualMFADevice.html
     *
     * @experimental
     */
    toDeleteVirtualMFADevice() {
        this.to('iam:DeleteVirtualMFADevice');
        return this;
    }
    /**
     * (experimental) Grants permission to detach a managed policy from the specified IAM group.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachGroupPolicy.html
     *
     * @experimental
     */
    toDetachGroupPolicy() {
        this.to('iam:DetachGroupPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to detach a managed policy from the specified role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html
     *
     * @experimental
     */
    toDetachRolePolicy() {
        this.to('iam:DetachRolePolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to detach a managed policy from the specified IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html
     *
     * @experimental
     */
    toDetachUserPolicy() {
        this.to('iam:DetachUserPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to enable an MFA device and associate it with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_EnableMFADevice.html
     *
     * @experimental
     */
    toEnableMFADevice() {
        this.to('iam:EnableMFADevice');
        return this;
    }
    /**
     * (experimental) Grants permission to generate a credential report for the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html
     *
     * @experimental
     */
    toGenerateCredentialReport() {
        this.to('iam:GenerateCredentialReport');
        return this;
    }
    /**
     * (experimental) Grants permission to generate an access report for an AWS Organizations entity.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifOrganizationsPolicyId()
     *
     * Dependent actions:
     * - organizations:DescribePolicy
     * - organizations:ListChildren
     * - organizations:ListParents
     * - organizations:ListPoliciesForTarget
     * - organizations:ListRoots
     * - organizations:ListTargetsForPolicy
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateOrganizationsAccessReport.html
     *
     * @experimental
     */
    toGenerateOrganizationsAccessReport() {
        this.to('iam:GenerateOrganizationsAccessReport');
        return this;
    }
    /**
     * (experimental) Grants permission to generate a service last accessed data report for an IAM resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateServiceLastAccessedDetails.html
     *
     * @experimental
     */
    toGenerateServiceLastAccessedDetails() {
        this.to('iam:GenerateServiceLastAccessedDetails');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about when the specified access key was last used.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccessKeyLastUsed.html
     *
     * @experimental
     */
    toGetAccessKeyLastUsed() {
        this.to('iam:GetAccessKeyLastUsed');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about all IAM users, groups, roles, and policies in your AWS account, including their relationships to one another.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountAuthorizationDetails.html
     *
     * @experimental
     */
    toGetAccountAuthorizationDetails() {
        this.to('iam:GetAccountAuthorizationDetails');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the password policy for the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountPasswordPolicy.html
     *
     * @experimental
     */
    toGetAccountPasswordPolicy() {
        this.to('iam:GetAccountPasswordPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about IAM entity usage and IAM quotas in the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountSummary.html
     *
     * @experimental
     */
    toGetAccountSummary() {
        this.to('iam:GetAccountSummary');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve a list of all of the context keys that are referenced in the specified policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForCustomPolicy.html
     *
     * @experimental
     */
    toGetContextKeysForCustomPolicy() {
        this.to('iam:GetContextKeysForCustomPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve a list of all context keys that are referenced in all IAM policies that are attached to the specified IAM identity (user, group, or role).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForPrincipalPolicy.html
     *
     * @experimental
     */
    toGetContextKeysForPrincipalPolicy() {
        this.to('iam:GetContextKeysForPrincipalPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve a credential report for the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetCredentialReport.html
     *
     * @experimental
     */
    toGetCredentialReport() {
        this.to('iam:GetCredentialReport');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve a list of IAM users in the specified IAM group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroup.html
     *
     * @experimental
     */
    toGetGroup() {
        this.to('iam:GetGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve an inline policy document that is embedded in the specified IAM group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroupPolicy.html
     *
     * @experimental
     */
    toGetGroupPolicy() {
        this.to('iam:GetGroupPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the specified instance profile, including the instance profile's path, GUID, ARN, and role.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetInstanceProfile.html
     *
     * @experimental
     */
    toGetInstanceProfile() {
        this.to('iam:GetInstanceProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the user name and password creation date for the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetLoginProfile.html
     *
     * @experimental
     */
    toGetLoginProfile() {
        this.to('iam:GetLoginProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the specified OpenID Connect (OIDC) provider resource in IAM.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOpenIDConnectProvider.html
     *
     * @experimental
     */
    toGetOpenIDConnectProvider() {
        this.to('iam:GetOpenIDConnectProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve an AWS Organizations access report.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOrganizationsAccessReport.html
     *
     * @experimental
     */
    toGetOrganizationsAccessReport() {
        this.to('iam:GetOrganizationsAccessReport');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the specified managed policy, including the policy's default version and the total number of identities to which the policy is attached.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html
     *
     * @experimental
     */
    toGetPolicy() {
        this.to('iam:GetPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about a version of the specified managed policy, including the policy document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html
     *
     * @experimental
     */
    toGetPolicyVersion() {
        this.to('iam:GetPolicyVersion');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the specified role, including the role's path, GUID, ARN, and the role's trust policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRole.html
     *
     * @experimental
     */
    toGetRole() {
        this.to('iam:GetRole');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve an inline policy document that is embedded with the specified IAM role.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRolePolicy.html
     *
     * @experimental
     */
    toGetRolePolicy() {
        this.to('iam:GetRolePolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the SAML provider metadocument that was uploaded when the IAM SAML provider resource was created or updated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetSAMLProvider.html
     *
     * @experimental
     */
    toGetSAMLProvider() {
        this.to('iam:GetSAMLProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the specified SSH public key, including metadata about the key.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetSSHPublicKey.html
     *
     * @experimental
     */
    toGetSSHPublicKey() {
        this.to('iam:GetSSHPublicKey');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the specified server certificate stored in IAM.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServerCertificate.html
     *
     * @experimental
     */
    toGetServerCertificate() {
        this.to('iam:GetServerCertificate');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the service last accessed data report.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetails.html
     *
     * @experimental
     */
    toGetServiceLastAccessedDetails() {
        this.to('iam:GetServiceLastAccessedDetails');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the entities from the service last accessed data report.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetailsWithEntities.html
     *
     * @experimental
     */
    toGetServiceLastAccessedDetailsWithEntities() {
        this.to('iam:GetServiceLastAccessedDetailsWithEntities');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve an IAM service-linked role deletion status.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLinkedRoleDeletionStatus.html
     *
     * @experimental
     */
    toGetServiceLinkedRoleDeletionStatus() {
        this.to('iam:GetServiceLinkedRoleDeletionStatus');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUser.html
     *
     * @experimental
     */
    toGetUser() {
        this.to('iam:GetUser');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve an inline policy document that is embedded in the specified IAM user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUserPolicy.html
     *
     * @experimental
     */
    toGetUserPolicy() {
        this.to('iam:GetUserPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to list information about the access key IDs that are associated with the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAccessKeys.html
     *
     * @experimental
     */
    toListAccessKeys() {
        this.to('iam:ListAccessKeys');
        return this;
    }
    /**
     * (experimental) Grants permission to list the account alias that is associated with the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAccountAliases.html
     *
     * @experimental
     */
    toListAccountAliases() {
        this.to('iam:ListAccountAliases');
        return this;
    }
    /**
     * (experimental) Grants permission to list all managed policies that are attached to the specified IAM group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedGroupPolicies.html
     *
     * @experimental
     */
    toListAttachedGroupPolicies() {
        this.to('iam:ListAttachedGroupPolicies');
        return this;
    }
    /**
     * (experimental) Grants permission to list all managed policies that are attached to the specified IAM role.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedRolePolicies.html
     *
     * @experimental
     */
    toListAttachedRolePolicies() {
        this.to('iam:ListAttachedRolePolicies');
        return this;
    }
    /**
     * (experimental) Grants permission to list all managed policies that are attached to the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedUserPolicies.html
     *
     * @experimental
     */
    toListAttachedUserPolicies() {
        this.to('iam:ListAttachedUserPolicies');
        return this;
    }
    /**
     * (experimental) Grants permission to list all IAM identities to which the specified managed policy is attached.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListEntitiesForPolicy.html
     *
     * @experimental
     */
    toListEntitiesForPolicy() {
        this.to('iam:ListEntitiesForPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to list the names of the inline policies that are embedded in the specified IAM group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroupPolicies.html
     *
     * @experimental
     */
    toListGroupPolicies() {
        this.to('iam:ListGroupPolicies');
        return this;
    }
    /**
     * (experimental) Grants permission to list the IAM groups that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroups.html
     *
     * @experimental
     */
    toListGroups() {
        this.to('iam:ListGroups');
        return this;
    }
    /**
     * (experimental) Grants permission to list the IAM groups that the specified IAM user belongs to.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroupsForUser.html
     *
     * @experimental
     */
    toListGroupsForUser() {
        this.to('iam:ListGroupsForUser');
        return this;
    }
    /**
     * (experimental) Grants permission to list the instance profiles that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfiles.html
     *
     * @experimental
     */
    toListInstanceProfiles() {
        this.to('iam:ListInstanceProfiles');
        return this;
    }
    /**
     * (experimental) Grants permission to list the instance profiles that have the specified associated IAM role.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfilesForRole.html
     *
     * @experimental
     */
    toListInstanceProfilesForRole() {
        this.to('iam:ListInstanceProfilesForRole');
        return this;
    }
    /**
     * (experimental) Grants permission to list the MFA devices for an IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListMFADevices.html
     *
     * @experimental
     */
    toListMFADevices() {
        this.to('iam:ListMFADevices');
        return this;
    }
    /**
     * (experimental) Grants permission to list information about the IAM OpenID Connect (OIDC) provider resource objects that are defined in the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListOpenIDConnectProviders.html
     *
     * @experimental
     */
    toListOpenIDConnectProviders() {
        this.to('iam:ListOpenIDConnectProviders');
        return this;
    }
    /**
     * (experimental) Grants permission to list all managed policies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicies.html
     *
     * @experimental
     */
    toListPolicies() {
        this.to('iam:ListPolicies');
        return this;
    }
    /**
     * (experimental) Grants permission to list information about the policies that grant an entity access to a specific service.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPoliciesGrantingServiceAccess.html
     *
     * @experimental
     */
    toListPoliciesGrantingServiceAccess() {
        this.to('iam:ListPoliciesGrantingServiceAccess');
        return this;
    }
    /**
     * (experimental) Grants permission to list information about the versions of the specified managed policy, including the version that is currently set as the policy's default version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html
     *
     * @experimental
     */
    toListPolicyVersions() {
        this.to('iam:ListPolicyVersions');
        return this;
    }
    /**
     * (experimental) Grants permission to list the names of the inline policies that are embedded in the specified IAM role.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRolePolicies.html
     *
     * @experimental
     */
    toListRolePolicies() {
        this.to('iam:ListRolePolicies');
        return this;
    }
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified IAM role.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRoleTags.html
     *
     * @experimental
     */
    toListRoleTags() {
        this.to('iam:ListRoleTags');
        return this;
    }
    /**
     * (experimental) Grants permission to list the IAM roles that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRoles.html
     *
     * @experimental
     */
    toListRoles() {
        this.to('iam:ListRoles');
        return this;
    }
    /**
     * (experimental) Grants permission to list the SAML provider resources in IAM.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSAMLProviders.html
     *
     * @experimental
     */
    toListSAMLProviders() {
        this.to('iam:ListSAMLProviders');
        return this;
    }
    /**
     * (experimental) Grants permission to list information about the SSH public keys that are associated with the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSSHPublicKeys.html
     *
     * @experimental
     */
    toListSSHPublicKeys() {
        this.to('iam:ListSSHPublicKeys');
        return this;
    }
    /**
     * (experimental) Grants permission to list the server certificates that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListServerCertificates.html
     *
     * @experimental
     */
    toListServerCertificates() {
        this.to('iam:ListServerCertificates');
        return this;
    }
    /**
     * (experimental) Grants permission to list the service-specific credentials that are associated with the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListServiceSpecificCredentials.html
     *
     * @experimental
     */
    toListServiceSpecificCredentials() {
        this.to('iam:ListServiceSpecificCredentials');
        return this;
    }
    /**
     * (experimental) Grants permission to list information about the signing certificates that are associated with the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSigningCertificates.html
     *
     * @experimental
     */
    toListSigningCertificates() {
        this.to('iam:ListSigningCertificates');
        return this;
    }
    /**
     * (experimental) Grants permission to list the names of the inline policies that are embedded in the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUserPolicies.html
     *
     * @experimental
     */
    toListUserPolicies() {
        this.to('iam:ListUserPolicies');
        return this;
    }
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUserTags.html
     *
     * @experimental
     */
    toListUserTags() {
        this.to('iam:ListUserTags');
        return this;
    }
    /**
     * (experimental) Grants permission to list the IAM users that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUsers.html
     *
     * @experimental
     */
    toListUsers() {
        this.to('iam:ListUsers');
        return this;
    }
    /**
     * (experimental) Grants permission to list virtual MFA devices by assignment status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListVirtualMFADevices.html
     *
     * @experimental
     */
    toListVirtualMFADevices() {
        this.to('iam:ListVirtualMFADevices');
        return this;
    }
    /**
     * (experimental) Grants permission to pass a role to a service.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAssociatedResourceArn()
     * - .ifPassedToService()
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html
     *
     * @experimental
     */
    toPassRole() {
        this.to('iam:PassRole');
        return this;
    }
    /**
     * (experimental) Grants permission to create or update an inline policy document that is embedded in the specified IAM group.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutGroupPolicy.html
     *
     * @experimental
     */
    toPutGroupPolicy() {
        this.to('iam:PutGroupPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to set a managed policy as a permissions boundary for a role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePermissionsBoundary.html
     *
     * @experimental
     */
    toPutRolePermissionsBoundary() {
        this.to('iam:PutRolePermissionsBoundary');
        return this;
    }
    /**
     * (experimental) Grants permission to create or update an inline policy document that is embedded in the specified IAM role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePolicy.html
     *
     * @experimental
     */
    toPutRolePolicy() {
        this.to('iam:PutRolePolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to set a managed policy as a permissions boundary for an IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPermissionsBoundary.html
     *
     * @experimental
     */
    toPutUserPermissionsBoundary() {
        this.to('iam:PutUserPermissionsBoundary');
        return this;
    }
    /**
     * (experimental) Grants permission to create or update an inline policy document that is embedded in the specified IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPolicy.html
     *
     * @experimental
     */
    toPutUserPolicy() {
        this.to('iam:PutUserPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to remove the client ID (audience) from the list of client IDs in the specified IAM OpenID Connect (OIDC) provider resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveClientIDFromOpenIDConnectProvider.html
     *
     * @experimental
     */
    toRemoveClientIDFromOpenIDConnectProvider() {
        this.to('iam:RemoveClientIDFromOpenIDConnectProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to remove an IAM role from the specified EC2 instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveRoleFromInstanceProfile.html
     *
     * @experimental
     */
    toRemoveRoleFromInstanceProfile() {
        this.to('iam:RemoveRoleFromInstanceProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to remove an IAM user from the specified group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveUserFromGroup.html
     *
     * @experimental
     */
    toRemoveUserFromGroup() {
        this.to('iam:RemoveUserFromGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to reset the password for an existing service-specific credential for an IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ResetServiceSpecificCredential.html
     *
     * @experimental
     */
    toResetServiceSpecificCredential() {
        this.to('iam:ResetServiceSpecificCredential');
        return this;
    }
    /**
     * (experimental) Grants permission to synchronize the specified MFA device with its IAM entity (user or role).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ResyncMFADevice.html
     *
     * @experimental
     */
    toResyncMFADevice() {
        this.to('iam:ResyncMFADevice');
        return this;
    }
    /**
     * (experimental) Grants permission to set the version of the specified policy as the policy's default version.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SetDefaultPolicyVersion.html
     *
     * @experimental
     */
    toSetDefaultPolicyVersion() {
        this.to('iam:SetDefaultPolicyVersion');
        return this;
    }
    /**
     * (experimental) Grants permission to set the STS global endpoint token version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SetSecurityTokenServicePreferences.html
     *
     * @experimental
     */
    toSetSecurityTokenServicePreferences() {
        this.to('iam:SetSecurityTokenServicePreferences');
        return this;
    }
    /**
     * (experimental) Grants permission to simulate whether an identity-based policy or resource-based policy provides permissions for specific API operations and resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulateCustomPolicy.html
     *
     * @experimental
     */
    toSimulateCustomPolicy() {
        this.to('iam:SimulateCustomPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to simulate whether an identity-based policy that is attached to a specified IAM entity (user or role) provides permissions for specific API operations and resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html
     *
     * @experimental
     */
    toSimulatePrincipalPolicy() {
        this.to('iam:SimulatePrincipalPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to add tags to an IAM role.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagRole.html
     *
     * @experimental
     */
    toTagRole() {
        this.to('iam:TagRole');
        return this;
    }
    /**
     * (experimental) Grants permission to add tags to an IAM user.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagUser.html
     *
     * @experimental
     */
    toTagUser() {
        this.to('iam:TagUser');
        return this;
    }
    /**
     * (experimental) Grants permission to remove the specified tags from the role.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagRole.html
     *
     * @experimental
     */
    toUntagRole() {
        this.to('iam:UntagRole');
        return this;
    }
    /**
     * (experimental) Grants permission to remove the specified tags from the user.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagUser.html
     *
     * @experimental
     */
    toUntagUser() {
        this.to('iam:UntagUser');
        return this;
    }
    /**
     * (experimental) Grants permission to update the status of the specified access key as Active or Inactive.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAccessKey.html
     *
     * @experimental
     */
    toUpdateAccessKey() {
        this.to('iam:UpdateAccessKey');
        return this;
    }
    /**
     * (experimental) Grants permission to update the password policy settings for the AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAccountPasswordPolicy.html
     *
     * @experimental
     */
    toUpdateAccountPasswordPolicy() {
        this.to('iam:UpdateAccountPasswordPolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to update the policy that grants an IAM entity permission to assume a role.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html
     *
     * @experimental
     */
    toUpdateAssumeRolePolicy() {
        this.to('iam:UpdateAssumeRolePolicy');
        return this;
    }
    /**
     * (experimental) Grants permission to update the name or path of the specified IAM group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateGroup.html
     *
     * @experimental
     */
    toUpdateGroup() {
        this.to('iam:UpdateGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to change the password for the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateLoginProfile.html
     *
     * @experimental
     */
    toUpdateLoginProfile() {
        this.to('iam:UpdateLoginProfile');
        return this;
    }
    /**
     * (experimental) Grants permission to update the entire list of server certificate thumbprints that are associated with an OpenID Connect (OIDC) provider resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateOpenIDConnectProviderThumbprint.html
     *
     * @experimental
     */
    toUpdateOpenIDConnectProviderThumbprint() {
        this.to('iam:UpdateOpenIDConnectProviderThumbprint');
        return this;
    }
    /**
     * (experimental) Grants permission to update the description or maximum session duration setting of a role.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateRole.html
     *
     * @experimental
     */
    toUpdateRole() {
        this.to('iam:UpdateRole');
        return this;
    }
    /**
     * (experimental) Grants permission to update only the description of a role.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateRoleDescription.html
     *
     * @experimental
     */
    toUpdateRoleDescription() {
        this.to('iam:UpdateRoleDescription');
        return this;
    }
    /**
     * (experimental) Grants permission to update the metadata document for an existing SAML provider resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSAMLProvider.html
     *
     * @experimental
     */
    toUpdateSAMLProvider() {
        this.to('iam:UpdateSAMLProvider');
        return this;
    }
    /**
     * (experimental) Grants permission to update the status of an IAM user's SSH public key to active or inactive.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSSHPublicKey.html
     *
     * @experimental
     */
    toUpdateSSHPublicKey() {
        this.to('iam:UpdateSSHPublicKey');
        return this;
    }
    /**
     * (experimental) Grants permission to update the name or the path of the specified server certificate stored in IAM.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateServerCertificate.html
     *
     * @experimental
     */
    toUpdateServerCertificate() {
        this.to('iam:UpdateServerCertificate');
        return this;
    }
    /**
     * (experimental) Grants permission to update the status of a service-specific credential to active or inactive for an IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateServiceSpecificCredential.html
     *
     * @experimental
     */
    toUpdateServiceSpecificCredential() {
        this.to('iam:UpdateServiceSpecificCredential');
        return this;
    }
    /**
     * (experimental) Grants permission to update the status of the specified user signing certificate to active or disabled.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSigningCertificate.html
     *
     * @experimental
     */
    toUpdateSigningCertificate() {
        this.to('iam:UpdateSigningCertificate');
        return this;
    }
    /**
     * (experimental) Grants permission to update the name or the path of the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateUser.html
     *
     * @experimental
     */
    toUpdateUser() {
        this.to('iam:UpdateUser');
        return this;
    }
    /**
     * (experimental) Grants permission to upload an SSH public key and associate it with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadSSHPublicKey.html
     *
     * @experimental
     */
    toUploadSSHPublicKey() {
        this.to('iam:UploadSSHPublicKey');
        return this;
    }
    /**
     * (experimental) Grants permission to upload a server certificate entity for the AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadServerCertificate.html
     *
     * @experimental
     */
    toUploadServerCertificate() {
        this.to('iam:UploadServerCertificate');
        return this;
    }
    /**
     * (experimental) Grants permission to upload an X.509 signing certificate and associate it with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadSigningCertificate.html
     *
     * @experimental
     */
    toUploadSigningCertificate() {
        this.to('iam:UploadSigningCertificate');
        return this;
    }
    /**
     * (experimental) Adds a resource of type access-report to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-view-data-orgs.html
     *
     * @param entityPath - Identifier for the entityPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAccessReport(entityPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:access-report/${EntityPath}';
        arn = arn.replace('${EntityPath}', entityPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type assumed-role to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html
     *
     * @param roleName - Identifier for the roleName.
     * @param roleSessionName - Identifier for the roleSessionName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssumedRole(roleName, roleSessionName, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:assumed-role/${RoleName}/${RoleSessionName}';
        arn = arn.replace('${RoleName}', roleName);
        arn = arn.replace('${RoleSessionName}', roleSessionName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type federated-user to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html
     *
     * @param userName - Identifier for the userName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFederatedUser(userName, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:federated-user/${UserName}';
        arn = arn.replace('${UserName}', userName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type group to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups.html
     *
     * @param groupNameWithPath - Identifier for the groupNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onGroup(groupNameWithPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:group/${GroupNameWithPath}';
        arn = arn.replace('${GroupNameWithPath}', groupNameWithPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type instance-profile to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html
     *
     * @param instanceProfileNameWithPath - Identifier for the instanceProfileNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onInstanceProfile(instanceProfileNameWithPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:instance-profile/${InstanceProfileNameWithPath}';
        arn = arn.replace('${InstanceProfileNameWithPath}', instanceProfileNameWithPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type mfa to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa.html
     *
     * @param mfaTokenIdWithPath - Identifier for the mfaTokenIdWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onMfa(mfaTokenIdWithPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:mfa/${MfaTokenIdWithPath}';
        arn = arn.replace('${MfaTokenIdWithPath}', mfaTokenIdWithPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type oidc-provider to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc.html
     *
     * @param oidcProviderName - Identifier for the oidcProviderName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onOidcProvider(oidcProviderName, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:oidc-provider/${OidcProviderName}';
        arn = arn.replace('${OidcProviderName}', oidcProviderName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type policy to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html
     *
     * @param policyNameWithPath - Identifier for the policyNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPolicy(policyNameWithPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:policy/${PolicyNameWithPath}';
        arn = arn.replace('${PolicyNameWithPath}', policyNameWithPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type role to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html
     *
     * @param roleNameWithPath - Identifier for the roleNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRole(roleNameWithPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:role/${RoleNameWithPath}';
        arn = arn.replace('${RoleNameWithPath}', roleNameWithPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type saml-provider to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html
     *
     * @param samlProviderName - Identifier for the samlProviderName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSamlProvider(samlProviderName, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:saml-provider/${SamlProviderName}';
        arn = arn.replace('${SamlProviderName}', samlProviderName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type server-certificate to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html
     *
     * @param certificateNameWithPath - Identifier for the certificateNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onServerCertificate(certificateNameWithPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:server-certificate/${CertificateNameWithPath}';
        arn = arn.replace('${CertificateNameWithPath}', certificateNameWithPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type sms-mfa to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_enable_sms.html
     *
     * @param mfaTokenIdWithPath - Identifier for the mfaTokenIdWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSmsMfa(mfaTokenIdWithPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:sms-mfa/${MfaTokenIdWithPath}';
        arn = arn.replace('${MfaTokenIdWithPath}', mfaTokenIdWithPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type user to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
     *
     * @param userNameWithPath - Identifier for the userNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onUser(userNameWithPath, account, partition) {
        var arn = 'arn:${Partition}:iam::${Account}:user/${UserNameWithPath}';
        arn = arn.replace('${UserNameWithPath}', userNameWithPath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Filters access by the AWS service to which this role is attached.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_AWSServiceName
     *
     * Applies to actions:
     * - .toCreateServiceLinkedRole()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAWSServiceName(value, operator) {
        return this.if(`iam:AWSServiceName`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters by the resource that the role will be used on behalf of.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_AssociatedResourceArn
     *
     * Applies to actions:
     * - .toPassRole()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifAssociatedResourceArn(value, operator) {
        return this.if(`iam:AssociatedResourceArn`, value, operator || 'ArnLike');
    }
    /**
     * (experimental) Filters access by the ID of an AWS Organizations policy.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_OrganizationsPolicyId
     *
     * Applies to actions:
     * - .toGenerateOrganizationsAccessReport()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOrganizationsPolicyId(value, operator) {
        return this.if(`iam:OrganizationsPolicyId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the AWS service to which this role is passed.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PassedToService
     *
     * Applies to actions:
     * - .toPassRole()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPassedToService(value, operator) {
        return this.if(`iam:PassedToService`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access if the specified policy is set as the permissions boundary on the IAM entity (user or role).
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PermissionsBoundary
     *
     * Applies to actions:
     * - .toAttachRolePolicy()
     * - .toAttachUserPolicy()
     * - .toCreateRole()
     * - .toCreateUser()
     * - .toDeleteRolePermissionsBoundary()
     * - .toDeleteRolePolicy()
     * - .toDeleteUserPermissionsBoundary()
     * - .toDeleteUserPolicy()
     * - .toDetachRolePolicy()
     * - .toDetachUserPolicy()
     * - .toPutRolePermissionsBoundary()
     * - .toPutRolePolicy()
     * - .toPutUserPermissionsBoundary()
     * - .toPutUserPolicy()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPermissionsBoundary(value, operator) {
        return this.if(`iam:PermissionsBoundary`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the ARN of an IAM policy.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PolicyARN
     *
     * Applies to actions:
     * - .toAttachGroupPolicy()
     * - .toAttachRolePolicy()
     * - .toAttachUserPolicy()
     * - .toDetachGroupPolicy()
     * - .toDetachRolePolicy()
     * - .toDetachUserPolicy()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifPolicyARN(value, operator) {
        return this.if(`iam:PolicyARN`, value, operator || 'ArnLike');
    }
    /**
     * (experimental) Filters access by the tags attached to an IAM entity (user or role).
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_ResourceTag
     *
     * Applies to resource types:
     * - role
     * - user
     *
     * @param tagKey The tag key to check.
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTag(tagKey, value, operator) {
        return this.if(`iam:ResourceTag/${tagKey}`, value, operator || 'StringLike');
    }
}
exports.Iam = Iam;
//# sourceMappingURL=data:application/json;base64,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