import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
 *
 * @experimental
 */
export declare class AwsMarketplaceManagement extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Allows access to the File Upload page inside the AWS Marketplace Management Portal.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     *
     * @experimental
     */
    touploadFiles(): this;
    /**
     * (experimental) Allows access to the Marketing page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     *
     * @experimental
     */
    toviewMarketing(): this;
    /**
     * (experimental) Allows access to the Reports page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     *
     * @experimental
     */
    toviewReports(): this;
    /**
     * (experimental) Allows access to the Settings page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     *
     * @experimental
     */
    toviewSettings(): this;
    /**
     * (experimental) Allows access to the Customer Support Eligibility page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     *
     * @experimental
     */
    toviewSupport(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
