import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
 *
 * @experimental
 */
export declare class NeptuneDb extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Connect to database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/get-started.html
     *
     * @experimental
     */
    toconnect(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type database to the statement.
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/get-started.html
     *
     * @param cluster - Identifier for the cluster.
     * @param database - Identifier for the database.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDatabase(cluster: string, database: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
