import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [rds-data](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsdataapi.html).
 *
 * @experimental
 */
export declare class RdsData extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Runs a batch SQL statement over an array of data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BatchExecuteStatement.html
     *
     * @experimental
     */
    toBatchExecuteStatement(): this;
    /**
     * (experimental) Starts a SQL transaction.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BeginTransaction.html
     *
     * @experimental
     */
    toBeginTransaction(): this;
    /**
     * (experimental) Ends a SQL transaction started with the BeginTransaction operation and commits the changes.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - rds-data:BeginTransaction
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_CommitTransaction.html
     *
     * @experimental
     */
    toCommitTransaction(): this;
    /**
     * (experimental) Runs one or more SQL statements. This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteSql.html
     *
     * @experimental
     */
    toExecuteSql(): this;
    /**
     * (experimental) Runs a SQL statement against a database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteStatement.html
     *
     * @experimental
     */
    toExecuteStatement(): this;
    /**
     * (experimental) Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - rds-data:BeginTransaction
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_RollbackTransaction.html
     *
     * @experimental
     */
    toRollbackTransaction(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [rds-data](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrdsdataapi.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
