"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsoDirectory = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [sso-directory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsssodirectory.html).
 *
 * @experimental
 */
class SsoDirectory extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [sso-directory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsssodirectory.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'sso-directory';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AddMemberToGroup",
                "CompleteVirtualMfaDeviceRegistration",
                "CompleteWebAuthnDeviceRegistration",
                "CreateAlias",
                "CreateBearerToken",
                "CreateExternalIdPConfigurationForDirectory",
                "CreateGroup",
                "CreateProvisioningTenant",
                "CreateUser",
                "DeleteBearerToken",
                "DeleteExternalIdPCertificate",
                "DeleteExternalIdPConfigurationForDirectory",
                "DeleteGroup",
                "DeleteMfaDeviceForUser",
                "DeleteProvisioningTenant",
                "DeleteUser",
                "DisableExternalIdPConfigurationForDirectory",
                "DisableUser",
                "EnableExternalIdPConfigurationForDirectory",
                "EnableUser",
                "ImportExternalIdPCertificate",
                "RemoveMemberFromGroup",
                "StartVirtualMfaDeviceRegistration",
                "StartWebAuthnDeviceRegistration",
                "UpdateExternalIdPConfigurationForDirectory",
                "UpdateGroup",
                "UpdateMfaDeviceForUser",
                "UpdatePassword",
                "UpdateUser",
                "VerifyEmail"
            ],
            "Read": [
                "DescribeDirectory",
                "DescribeUser",
                "GetAWSSPConfigurationForDirectory",
                "IsMemberInGroup",
                "SearchGroups",
                "SearchUsers"
            ],
            "List": [
                "DescribeGroups",
                "DescribeUsers",
                "ListBearerTokens",
                "ListExternalIdPCertificates",
                "ListExternalIdPConfigurationsForDirectory",
                "ListGroupsForUser",
                "ListMembersInGroup",
                "ListMfaDevicesForUser",
                "ListProvisioningTenants"
            ]
        };
    }
    /**
     * (experimental) Grants permission to add a member to a group in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toAddMemberToGroup() {
        this.to('sso-directory:AddMemberToGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to complete the creation process of a virtual MFA device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCompleteVirtualMfaDeviceRegistration() {
        this.to('sso-directory:CompleteVirtualMfaDeviceRegistration');
        return this;
    }
    /**
     * (experimental) Grants permission to complete the registration process of a WebAuthn device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCompleteWebAuthnDeviceRegistration() {
        this.to('sso-directory:CompleteWebAuthnDeviceRegistration');
        return this;
    }
    /**
     * (experimental) Grants permission to create an alias for the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateAlias() {
        this.to('sso-directory:CreateAlias');
        return this;
    }
    /**
     * (experimental) Grants permission to create a bearer token for a given provisioning tenant.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateBearerToken() {
        this.to('sso-directory:CreateBearerToken');
        return this;
    }
    /**
     * (experimental) Grants permission to create an External Identity Provider configuration for the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateExternalIdPConfigurationForDirectory() {
        this.to('sso-directory:CreateExternalIdPConfigurationForDirectory');
        return this;
    }
    /**
     * (experimental) Grants permission to create a group in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateGroup() {
        this.to('sso-directory:CreateGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to create a provisioning tenant for a given directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateProvisioningTenant() {
        this.to('sso-directory:CreateProvisioningTenant');
        return this;
    }
    /**
     * (experimental) Grants permission to create a user in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateUser() {
        this.to('sso-directory:CreateUser');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a bearer token.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteBearerToken() {
        this.to('sso-directory:DeleteBearerToken');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the given external IdP certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteExternalIdPCertificate() {
        this.to('sso-directory:DeleteExternalIdPCertificate');
        return this;
    }
    /**
     * (experimental) Grants permission to delete an External Identity Provider configuration associated with the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteExternalIdPConfigurationForDirectory() {
        this.to('sso-directory:DeleteExternalIdPConfigurationForDirectory');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a group from the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteGroup() {
        this.to('sso-directory:DeleteGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a MFA device by device name for a given user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteMfaDeviceForUser() {
        this.to('sso-directory:DeleteMfaDeviceForUser');
        return this;
    }
    /**
     * (experimental) Grants permission to delete the provisioning tenant.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteProvisioningTenant() {
        this.to('sso-directory:DeleteProvisioningTenant');
        return this;
    }
    /**
     * (experimental) Grants permission to delete a user from the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteUser() {
        this.to('sso-directory:DeleteUser');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about the directory that AWS SSO provides by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeDirectory() {
        this.to('sso-directory:DescribeDirectory');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about a group from the directory that AWS SSO provides by default.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeGroups() {
        this.to('sso-directory:DescribeGroups');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about a user from the directory that AWS SSO provides by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeUser() {
        this.to('sso-directory:DescribeUser');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve information about user from the directory that AWS SSO provides by default.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeUsers() {
        this.to('sso-directory:DescribeUsers');
        return this;
    }
    /**
     * (experimental) Grants permission to disable authentication of end users with an External Identity Provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDisableExternalIdPConfigurationForDirectory() {
        this.to('sso-directory:DisableExternalIdPConfigurationForDirectory');
        return this;
    }
    /**
     * (experimental) Grants permission to deactivate a user in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDisableUser() {
        this.to('sso-directory:DisableUser');
        return this;
    }
    /**
     * (experimental) Grants permission to enable authentication of end users with an External Identity Provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toEnableExternalIdPConfigurationForDirectory() {
        this.to('sso-directory:EnableExternalIdPConfigurationForDirectory');
        return this;
    }
    /**
     * (experimental) Grants permission to activate user in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toEnableUser() {
        this.to('sso-directory:EnableUser');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve the AWS SSO Service Provider configurations for the directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetAWSSPConfigurationForDirectory() {
        this.to('sso-directory:GetAWSSPConfigurationForDirectory');
        return this;
    }
    /**
     * (experimental) Grants permission to import the IdP certificate used for verifying external IdP responses.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toImportExternalIdPCertificate() {
        this.to('sso-directory:ImportExternalIdPCertificate');
        return this;
    }
    /**
     * (experimental) Grants permission to check if a member is a part of the group in the directory that AWS SSO provides by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toIsMemberInGroup() {
        this.to('sso-directory:IsMemberInGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to list bearer tokens for a given provisioning tenant.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListBearerTokens() {
        this.to('sso-directory:ListBearerTokens');
        return this;
    }
    /**
     * (experimental) Grants permission to list the external IdP certificates of a given directory and IdP.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListExternalIdPCertificates() {
        this.to('sso-directory:ListExternalIdPCertificates');
        return this;
    }
    /**
     * (experimental) Grants permission to list all the External Identity Provider configurations created for the directory.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListExternalIdPConfigurationsForDirectory() {
        this.to('sso-directory:ListExternalIdPConfigurationsForDirectory');
        return this;
    }
    /**
     * (experimental) Grants permission to list groups for a user from the directory that AWS SSO provides by default.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListGroupsForUser() {
        this.to('sso-directory:ListGroupsForUser');
        return this;
    }
    /**
     * (experimental) Grants permission to retrieve all members that are part of a group in the directory that AWS SSO provides by default.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListMembersInGroup() {
        this.to('sso-directory:ListMembersInGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to list all active MFA devices and their MFA device metadata for a user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListMfaDevicesForUser() {
        this.to('sso-directory:ListMfaDevicesForUser');
        return this;
    }
    /**
     * (experimental) Grants permission to list provisioning tenants for a given directory.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListProvisioningTenants() {
        this.to('sso-directory:ListProvisioningTenants');
        return this;
    }
    /**
     * (experimental) Grants permission to remove a member that is part of a group in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toRemoveMemberFromGroup() {
        this.to('sso-directory:RemoveMemberFromGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to search for groups within the associated directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toSearchGroups() {
        this.to('sso-directory:SearchGroups');
        return this;
    }
    /**
     * (experimental) Grants permission to search for users within the associated directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toSearchUsers() {
        this.to('sso-directory:SearchUsers');
        return this;
    }
    /**
     * (experimental) Grants permission to begin the creation process of virtual mfa device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toStartVirtualMfaDeviceRegistration() {
        this.to('sso-directory:StartVirtualMfaDeviceRegistration');
        return this;
    }
    /**
     * (experimental) Grants permission to begin the registration process of a WebAuthn device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toStartWebAuthnDeviceRegistration() {
        this.to('sso-directory:StartWebAuthnDeviceRegistration');
        return this;
    }
    /**
     * (experimental) Grants permission to update an External Identity Provider configuration associated with the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateExternalIdPConfigurationForDirectory() {
        this.to('sso-directory:UpdateExternalIdPConfigurationForDirectory');
        return this;
    }
    /**
     * (experimental) Grants permission to update information about a group in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateGroup() {
        this.to('sso-directory:UpdateGroup');
        return this;
    }
    /**
     * (experimental) Grants permission to update MFA device information.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateMfaDeviceForUser() {
        this.to('sso-directory:UpdateMfaDeviceForUser');
        return this;
    }
    /**
     * (experimental) Grants permission to update a password by sending password reset link via email or generating one time password for a user in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdatePassword() {
        this.to('sso-directory:UpdatePassword');
        return this;
    }
    /**
     * (experimental) Grants permission to update user information in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateUser() {
        this.to('sso-directory:UpdateUser');
        return this;
    }
    /**
     * (experimental) Grants permission to verify an email address of an User.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toVerifyEmail() {
        this.to('sso-directory:VerifyEmail');
        return this;
    }
}
exports.SsoDirectory = SsoDirectory;
//# sourceMappingURL=data:application/json;base64,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