"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithCDKPrincipal = void 0;
// @ts-ignore only available after swapping 1-base
const iam = require("@aws-cdk/aws-iam");
const _6_principals_1 = require("./6-principals");
/**
 * (experimental) Adds CDK specific "principal" functionality to the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementWithCDKPrincipal extends _6_principals_1.PolicyStatementWithPrincipal {
    constructor() {
        super(...arguments);
        /**
         * @experimental
         */
        this.cdkPrincipals = [];
        this.cdkPrincipalsApplied = false;
    }
    /**
     * (experimental) Adds any number of CDK principals to the statement.
     *
     * @param principals Principals to add to the statement.
     * @experimental
     */
    forCdkPrincipal(...principals) {
        this.skipAutoResource = true;
        this.cdkPrincipals.push(...principals);
        return this;
    }
    /**
     * @experimental
     */
    cdkApplyPrincipals() {
        if (!this.cdkPrincipalsApplied) {
            const mode = this.useNotPrincipals ? 'addNotPrincipals' : 'addPrincipals';
            // @ts-ignore only available after swapping 1-base
            this[mode](...this.cdkPrincipals);
            if (this.hasPrincipals()) {
                Object.keys(this.principals).forEach((prefix) => {
                    switch (prefix) {
                        case _6_principals_1.PrincipalType.AWS:
                            this.principals[prefix].forEach((arn) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.ArnPrincipal(arn));
                            });
                            break;
                        case _6_principals_1.PrincipalType.CANONICAL_USER:
                            this.principals[prefix].forEach((userId) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.CanonicalUserPrincipal(userId));
                            });
                            break;
                        case _6_principals_1.PrincipalType.FEDERATED:
                            this.principals[prefix].forEach((provider) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.FederatedPrincipal(provider, {}));
                            });
                            break;
                        case _6_principals_1.PrincipalType.SERVICE:
                            this.principals[prefix].forEach((service) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.ServicePrincipal(service));
                            });
                            break;
                        default:
                            throw Error(`Unhandled principal type: ${prefix}`);
                    }
                });
            }
            this.cdkPrincipalsApplied = true;
        }
    }
}
exports.PolicyStatementWithCDKPrincipal = PolicyStatementWithCDKPrincipal;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNy1wcmluY2lwYWxzLUNESy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIjctcHJpbmNpcGFscy1DREsudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsa0RBQWtEO0FBQ2xELHdDQUF5QztBQUV6QyxrREFBNkU7Ozs7OztBQUs3RSxNQUFhLCtCQUFnQyxTQUFRLDRDQUE0QjtJQUFqRjs7Ozs7UUFDWSxrQkFBYSxHQUFxQixFQUFFLENBQUM7UUFDdkMseUJBQW9CLEdBQUcsS0FBSyxDQUFDO0lBb0R2QyxDQUFDOzs7Ozs7O0lBOUNRLGVBQWUsQ0FBQyxHQUFHLFVBQTRCO1FBQ3BELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUM7UUFDN0IsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsR0FBRyxVQUFVLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7SUFFUyxrQkFBa0I7UUFDMUIsSUFBSSxDQUFDLElBQUksQ0FBQyxvQkFBb0IsRUFBRTtZQUM5QixNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxlQUFlLENBQUM7WUFDMUUsa0RBQWtEO1lBQ2xELElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUNsQyxJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUUsRUFBRTtnQkFDeEIsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUU7b0JBQzlDLFFBQVEsTUFBTSxFQUFFO3dCQUNkLEtBQUssNkJBQWEsQ0FBQyxHQUFHOzRCQUNwQixJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFO2dDQUN0QyxrREFBa0Q7Z0NBQ2xELElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQzs0QkFDeEMsQ0FBQyxDQUFDLENBQUM7NEJBQ0gsTUFBTTt3QkFDUixLQUFLLDZCQUFhLENBQUMsY0FBYzs0QkFDL0IsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtnQ0FDekMsa0RBQWtEO2dDQUNsRCxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxHQUFHLENBQUMsc0JBQXNCLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQzs0QkFDckQsQ0FBQyxDQUFDLENBQUM7NEJBQ0gsTUFBTTt3QkFDUixLQUFLLDZCQUFhLENBQUMsU0FBUzs0QkFDMUIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxRQUFRLEVBQUUsRUFBRTtnQ0FDM0Msa0RBQWtEO2dDQUNsRCxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7NEJBQ3ZELENBQUMsQ0FBQyxDQUFDOzRCQUNILE1BQU07d0JBQ1IsS0FBSyw2QkFBYSxDQUFDLE9BQU87NEJBQ3hCLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUU7Z0NBQzFDLGtEQUFrRDtnQ0FDbEQsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7NEJBQ2hELENBQUMsQ0FBQyxDQUFDOzRCQUNILE1BQU07d0JBQ1I7NEJBQ0UsTUFBTSxLQUFLLENBQUMsNkJBQTZCLE1BQU0sRUFBRSxDQUFDLENBQUM7cUJBQ3REO2dCQUNILENBQUMsQ0FBQyxDQUFDO2FBQ0o7WUFDRCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsSUFBSSxDQUFDO1NBQ2xDO0lBQ0gsQ0FBQztDQUNGO0FBdERELDBFQXNEQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIEB0cy1pZ25vcmUgb25seSBhdmFpbGFibGUgYWZ0ZXIgc3dhcHBpbmcgMS1iYXNlXG5pbXBvcnQgaWFtID0gcmVxdWlyZSgnQGF3cy1jZGsvYXdzLWlhbScpO1xuXG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnRXaXRoUHJpbmNpcGFsLCBQcmluY2lwYWxUeXBlIH0gZnJvbSAnLi82LXByaW5jaXBhbHMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBQb2xpY3lTdGF0ZW1lbnRXaXRoQ0RLUHJpbmNpcGFsIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50V2l0aFByaW5jaXBhbCB7XG4gIHByb3RlY3RlZCBjZGtQcmluY2lwYWxzOiBpYW0uSVByaW5jaXBhbFtdID0gW107XG4gIHByaXZhdGUgY2RrUHJpbmNpcGFsc0FwcGxpZWQgPSBmYWxzZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGZvckNka1ByaW5jaXBhbCguLi5wcmluY2lwYWxzOiBpYW0uSVByaW5jaXBhbFtdKSB7XG4gICAgdGhpcy5za2lwQXV0b1Jlc291cmNlID0gdHJ1ZTtcbiAgICB0aGlzLmNka1ByaW5jaXBhbHMucHVzaCguLi5wcmluY2lwYWxzKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHByb3RlY3RlZCBjZGtBcHBseVByaW5jaXBhbHMoKSB7XG4gICAgaWYgKCF0aGlzLmNka1ByaW5jaXBhbHNBcHBsaWVkKSB7XG4gICAgICBjb25zdCBtb2RlID0gdGhpcy51c2VOb3RQcmluY2lwYWxzID8gJ2FkZE5vdFByaW5jaXBhbHMnIDogJ2FkZFByaW5jaXBhbHMnO1xuICAgICAgLy8gQHRzLWlnbm9yZSBvbmx5IGF2YWlsYWJsZSBhZnRlciBzd2FwcGluZyAxLWJhc2VcbiAgICAgIHRoaXNbbW9kZV0oLi4udGhpcy5jZGtQcmluY2lwYWxzKTtcbiAgICAgIGlmICh0aGlzLmhhc1ByaW5jaXBhbHMoKSkge1xuICAgICAgICBPYmplY3Qua2V5cyh0aGlzLnByaW5jaXBhbHMpLmZvckVhY2goKHByZWZpeCkgPT4ge1xuICAgICAgICAgIHN3aXRjaCAocHJlZml4KSB7XG4gICAgICAgICAgICBjYXNlIFByaW5jaXBhbFR5cGUuQVdTOlxuICAgICAgICAgICAgICB0aGlzLnByaW5jaXBhbHNbcHJlZml4XS5mb3JFYWNoKChhcm4pID0+IHtcbiAgICAgICAgICAgICAgICAvLyBAdHMtaWdub3JlIG9ubHkgYXZhaWxhYmxlIGFmdGVyIHN3YXBwaW5nIDEtYmFzZVxuICAgICAgICAgICAgICAgIHRoaXNbbW9kZV0obmV3IGlhbS5Bcm5QcmluY2lwYWwoYXJuKSk7XG4gICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIGNhc2UgUHJpbmNpcGFsVHlwZS5DQU5PTklDQUxfVVNFUjpcbiAgICAgICAgICAgICAgdGhpcy5wcmluY2lwYWxzW3ByZWZpeF0uZm9yRWFjaCgodXNlcklkKSA9PiB7XG4gICAgICAgICAgICAgICAgLy8gQHRzLWlnbm9yZSBvbmx5IGF2YWlsYWJsZSBhZnRlciBzd2FwcGluZyAxLWJhc2VcbiAgICAgICAgICAgICAgICB0aGlzW21vZGVdKG5ldyBpYW0uQ2Fub25pY2FsVXNlclByaW5jaXBhbCh1c2VySWQpKTtcbiAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgY2FzZSBQcmluY2lwYWxUeXBlLkZFREVSQVRFRDpcbiAgICAgICAgICAgICAgdGhpcy5wcmluY2lwYWxzW3ByZWZpeF0uZm9yRWFjaCgocHJvdmlkZXIpID0+IHtcbiAgICAgICAgICAgICAgICAvLyBAdHMtaWdub3JlIG9ubHkgYXZhaWxhYmxlIGFmdGVyIHN3YXBwaW5nIDEtYmFzZVxuICAgICAgICAgICAgICAgIHRoaXNbbW9kZV0obmV3IGlhbS5GZWRlcmF0ZWRQcmluY2lwYWwocHJvdmlkZXIsIHt9KSk7XG4gICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIGNhc2UgUHJpbmNpcGFsVHlwZS5TRVJWSUNFOlxuICAgICAgICAgICAgICB0aGlzLnByaW5jaXBhbHNbcHJlZml4XS5mb3JFYWNoKChzZXJ2aWNlKSA9PiB7XG4gICAgICAgICAgICAgICAgLy8gQHRzLWlnbm9yZSBvbmx5IGF2YWlsYWJsZSBhZnRlciBzd2FwcGluZyAxLWJhc2VcbiAgICAgICAgICAgICAgICB0aGlzW21vZGVdKG5ldyBpYW0uU2VydmljZVByaW5jaXBhbChzZXJ2aWNlKSk7XG4gICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIGRlZmF1bHQ6XG4gICAgICAgICAgICAgIHRocm93IEVycm9yKGBVbmhhbmRsZWQgcHJpbmNpcGFsIHR5cGU6ICR7cHJlZml4fWApO1xuICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgICB0aGlzLmNka1ByaW5jaXBhbHNBcHBsaWVkID0gdHJ1ZTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==