# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkAssociateV2Args', 'NetworkAssociateV2']

@pulumi.input_type
class NetworkAssociateV2Args:
    def __init__(__self__, *,
                 bgpvpn_id: pulumi.Input[_builtins.str],
                 network_id: pulumi.Input[_builtins.str],
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkAssociateV2 resource.
        :param pulumi.Input[_builtins.str] bgpvpn_id: The ID of the BGP VPN to which the network will be
               associated. Changing this creates a new BGP VPN network association
        :param pulumi.Input[_builtins.str] network_id: The ID of the network to be associated with the BGP
               VPN. Changing this creates a new BGP VPN network association.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project that owns the BGP VPN network
               association. Only administrative and users with `advsvc` role can specify a
               project ID other than their own. Changing this creates a new BGP VPN network
               association.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a BGP VPN network association. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new BGP VPN network association.
        """
        pulumi.set(__self__, "bgpvpn_id", bgpvpn_id)
        pulumi.set(__self__, "network_id", network_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="bgpvpnId")
    def bgpvpn_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the BGP VPN to which the network will be
        associated. Changing this creates a new BGP VPN network association
        """
        return pulumi.get(self, "bgpvpn_id")

    @bgpvpn_id.setter
    def bgpvpn_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bgpvpn_id", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the network to be associated with the BGP
        VPN. Changing this creates a new BGP VPN network association.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project that owns the BGP VPN network
        association. Only administrative and users with `advsvc` role can specify a
        project ID other than their own. Changing this creates a new BGP VPN network
        association.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a BGP VPN network association. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new BGP VPN network association.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NetworkAssociateV2State:
    def __init__(__self__, *,
                 bgpvpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkAssociateV2 resources.
        :param pulumi.Input[_builtins.str] bgpvpn_id: The ID of the BGP VPN to which the network will be
               associated. Changing this creates a new BGP VPN network association
        :param pulumi.Input[_builtins.str] network_id: The ID of the network to be associated with the BGP
               VPN. Changing this creates a new BGP VPN network association.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project that owns the BGP VPN network
               association. Only administrative and users with `advsvc` role can specify a
               project ID other than their own. Changing this creates a new BGP VPN network
               association.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a BGP VPN network association. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new BGP VPN network association.
        """
        if bgpvpn_id is not None:
            pulumi.set(__self__, "bgpvpn_id", bgpvpn_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="bgpvpnId")
    def bgpvpn_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the BGP VPN to which the network will be
        associated. Changing this creates a new BGP VPN network association
        """
        return pulumi.get(self, "bgpvpn_id")

    @bgpvpn_id.setter
    def bgpvpn_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgpvpn_id", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the network to be associated with the BGP
        VPN. Changing this creates a new BGP VPN network association.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project that owns the BGP VPN network
        association. Only administrative and users with `advsvc` role can specify a
        project ID other than their own. Changing this creates a new BGP VPN network
        association.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a BGP VPN network association. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new BGP VPN network association.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("openstack:bgpvpn/networkAssociateV2:NetworkAssociateV2")
class NetworkAssociateV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgpvpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a V2 BGP VPN network association resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        association1 = openstack.bgpvpn.NetworkAssociateV2("association_1",
            bgpvpn_id="e7189337-5684-46ee-bcb1-44f1a57066c9",
            network_id="de83d56c-4d2f-44f7-ac24-af393252204f")
        ```

        ## Import

        BGP VPN network associations can be imported using the BGP VPN ID and BGP VPN

        network association ID separated by a slash, e.g.:

        hcl

        ```sh
        $ pulumi import openstack:bgpvpn/networkAssociateV2:NetworkAssociateV2 association_1 2145aaa9-edaa-44fb-9815-e47a96677a72/67bb952a-f9d1-4fc8-ae84-082253a879d4
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bgpvpn_id: The ID of the BGP VPN to which the network will be
               associated. Changing this creates a new BGP VPN network association
        :param pulumi.Input[_builtins.str] network_id: The ID of the network to be associated with the BGP
               VPN. Changing this creates a new BGP VPN network association.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project that owns the BGP VPN network
               association. Only administrative and users with `advsvc` role can specify a
               project ID other than their own. Changing this creates a new BGP VPN network
               association.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a BGP VPN network association. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new BGP VPN network association.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAssociateV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 BGP VPN network association resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        association1 = openstack.bgpvpn.NetworkAssociateV2("association_1",
            bgpvpn_id="e7189337-5684-46ee-bcb1-44f1a57066c9",
            network_id="de83d56c-4d2f-44f7-ac24-af393252204f")
        ```

        ## Import

        BGP VPN network associations can be imported using the BGP VPN ID and BGP VPN

        network association ID separated by a slash, e.g.:

        hcl

        ```sh
        $ pulumi import openstack:bgpvpn/networkAssociateV2:NetworkAssociateV2 association_1 2145aaa9-edaa-44fb-9815-e47a96677a72/67bb952a-f9d1-4fc8-ae84-082253a879d4
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAssociateV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAssociateV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgpvpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAssociateV2Args.__new__(NetworkAssociateV2Args)

            if bgpvpn_id is None and not opts.urn:
                raise TypeError("Missing required property 'bgpvpn_id'")
            __props__.__dict__["bgpvpn_id"] = bgpvpn_id
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="openstack:index/bgpvpnNetworkAssociateV2:BgpvpnNetworkAssociateV2")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(NetworkAssociateV2, __self__).__init__(
            'openstack:bgpvpn/networkAssociateV2:NetworkAssociateV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bgpvpn_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkAssociateV2':
        """
        Get an existing NetworkAssociateV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bgpvpn_id: The ID of the BGP VPN to which the network will be
               associated. Changing this creates a new BGP VPN network association
        :param pulumi.Input[_builtins.str] network_id: The ID of the network to be associated with the BGP
               VPN. Changing this creates a new BGP VPN network association.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project that owns the BGP VPN network
               association. Only administrative and users with `advsvc` role can specify a
               project ID other than their own. Changing this creates a new BGP VPN network
               association.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a BGP VPN network association. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new BGP VPN network association.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAssociateV2State.__new__(_NetworkAssociateV2State)

        __props__.__dict__["bgpvpn_id"] = bgpvpn_id
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        return NetworkAssociateV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bgpvpnId")
    def bgpvpn_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the BGP VPN to which the network will be
        associated. Changing this creates a new BGP VPN network association
        """
        return pulumi.get(self, "bgpvpn_id")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the network to be associated with the BGP
        VPN. Changing this creates a new BGP VPN network association.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project that owns the BGP VPN network
        association. Only administrative and users with `advsvc` role can specify a
        project ID other than their own. Changing this creates a new BGP VPN network
        association.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a BGP VPN network association. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new BGP VPN network association.
        """
        return pulumi.get(self, "region")

