# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFlavorprofileV2Result',
    'AwaitableGetFlavorprofileV2Result',
    'get_flavorprofile_v2',
    'get_flavorprofile_v2_output',
]

@pulumi.output_type
class GetFlavorprofileV2Result:
    """
    A collection of values returned by getFlavorprofileV2.
    """
    def __init__(__self__, flavor_data=None, flavorprofile_id=None, id=None, name=None, provider_name=None, region=None):
        if flavor_data and not isinstance(flavor_data, str):
            raise TypeError("Expected argument 'flavor_data' to be a str")
        pulumi.set(__self__, "flavor_data", flavor_data)
        if flavorprofile_id and not isinstance(flavorprofile_id, str):
            raise TypeError("Expected argument 'flavorprofile_id' to be a str")
        pulumi.set(__self__, "flavorprofile_id", flavorprofile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="flavorData")
    def flavor_data(self) -> _builtins.str:
        """
        Extra data of the flavorprofile depending on the provider.
        """
        return pulumi.get(self, "flavor_data")

    @_builtins.property
    @pulumi.getter(name="flavorprofileId")
    def flavorprofile_id(self) -> _builtins.str:
        return pulumi.get(self, "flavorprofile_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the flavorprofile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> _builtins.str:
        """
        The name of the provider that the flavorprofile uses.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetFlavorprofileV2Result(GetFlavorprofileV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorprofileV2Result(
            flavor_data=self.flavor_data,
            flavorprofile_id=self.flavorprofile_id,
            id=self.id,
            name=self.name,
            provider_name=self.provider_name,
            region=self.region)


def get_flavorprofile_v2(flavorprofile_id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         provider_name: Optional[_builtins.str] = None,
                         region: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorprofileV2Result:
    """
    Use this data source to get the ID of an OpenStack Load Balancer flavorprofile.

    > **Note:** This usually requires admin privileges.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    fp1 = openstack.loadbalancer.get_flavorprofile_v2(name="flavorprofile_1")
    ```


    :param _builtins.str flavorprofile_id: The ID of the flavorprofile. Conflicts with `name` and
           `provider_name`.
    :param _builtins.str name: The name of the flavorprofile. Conflicts with `flavorprofile_id`.
    :param _builtins.str provider_name: The name of the provider that the flavorprofile uses. Conflicts
           with `flavorprofile_id`.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer client.
           If omitted, the `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['flavorprofileId'] = flavorprofile_id
    __args__['name'] = name
    __args__['providerName'] = provider_name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:loadbalancer/getFlavorprofileV2:getFlavorprofileV2', __args__, opts=opts, typ=GetFlavorprofileV2Result).value

    return AwaitableGetFlavorprofileV2Result(
        flavor_data=pulumi.get(__ret__, 'flavor_data'),
        flavorprofile_id=pulumi.get(__ret__, 'flavorprofile_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        provider_name=pulumi.get(__ret__, 'provider_name'),
        region=pulumi.get(__ret__, 'region'))
def get_flavorprofile_v2_output(flavorprofile_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                provider_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlavorprofileV2Result]:
    """
    Use this data source to get the ID of an OpenStack Load Balancer flavorprofile.

    > **Note:** This usually requires admin privileges.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    fp1 = openstack.loadbalancer.get_flavorprofile_v2(name="flavorprofile_1")
    ```


    :param _builtins.str flavorprofile_id: The ID of the flavorprofile. Conflicts with `name` and
           `provider_name`.
    :param _builtins.str name: The name of the flavorprofile. Conflicts with `flavorprofile_id`.
    :param _builtins.str provider_name: The name of the provider that the flavorprofile uses. Conflicts
           with `flavorprofile_id`.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer client.
           If omitted, the `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['flavorprofileId'] = flavorprofile_id
    __args__['name'] = name
    __args__['providerName'] = provider_name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:loadbalancer/getFlavorprofileV2:getFlavorprofileV2', __args__, opts=opts, typ=GetFlavorprofileV2Result)
    return __ret__.apply(lambda __response__: GetFlavorprofileV2Result(
        flavor_data=pulumi.get(__response__, 'flavor_data'),
        flavorprofile_id=pulumi.get(__response__, 'flavorprofile_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        provider_name=pulumi.get(__response__, 'provider_name'),
        region=pulumi.get(__response__, 'region')))
