# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist 
from lusid.models.placement import Placement
from lusid.models.resource_id import ResourceId

class CancelledPlacementResult(BaseModel):
    """
    CancelledPlacementResult
    """
    placement_state: Optional[Placement] = Field(None, alias="placementState")
    cancelled_child_placements: conlist(ResourceId) = Field(..., alias="cancelledChildPlacements", description="Child placements which have also been cancelled following cancellation of the parent")
    __properties = ["placementState", "cancelledChildPlacements"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CancelledPlacementResult:
        """Create an instance of CancelledPlacementResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of placement_state
        if self.placement_state:
            _dict['placementState'] = self.placement_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in cancelled_child_placements (list)
        _items = []
        if self.cancelled_child_placements:
            for _item in self.cancelled_child_placements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cancelledChildPlacements'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CancelledPlacementResult:
        """Create an instance of CancelledPlacementResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CancelledPlacementResult.parse_obj(obj)

        _obj = CancelledPlacementResult.parse_obj({
            "placement_state": Placement.from_dict(obj.get("placementState")) if obj.get("placementState") is not None else None,
            "cancelled_child_placements": [ResourceId.from_dict(_item) for _item in obj.get("cancelledChildPlacements")] if obj.get("cancelledChildPlacements") is not None else None
        })
        return _obj
