# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist, constr 
from lusid.models.custom_entity_field import CustomEntityField
from lusid.models.custom_entity_id import CustomEntityId
from lusid.models.link import Link
from lusid.models.relationship import Relationship
from lusid.models.staged_modifications_info import StagedModificationsInfo
from lusid.models.version import Version

class CustomEntityResponse(BaseModel):
    """
    CustomEntityResponse
    """
    href:  Optional[StrictStr] = Field(None,alias="href", description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.") 
    entity_type:  StrictStr = Field(...,alias="entityType", description="The type of custom entity this is.") 
    version: Version = Field(...)
    staged_modifications: Optional[StagedModificationsInfo] = Field(None, alias="stagedModifications")
    display_name:  StrictStr = Field(...,alias="displayName", description="A display label for the custom entity.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A description of the custom entity.") 
    identifiers: conlist(CustomEntityId) = Field(..., description="The identifiers the custom entity will be upserted with.")
    fields: conlist(CustomEntityField) = Field(..., description="The fields that decorate the custom entity.")
    relationships: conlist(Relationship) = Field(..., description="A set of relationships associated to the custom entity.")
    links: Optional[conlist(Link)] = None
    __properties = ["href", "entityType", "version", "stagedModifications", "displayName", "description", "identifiers", "fields", "relationships", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomEntityResponse:
        """Create an instance of CustomEntityResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of staged_modifications
        if self.staged_modifications:
            _dict['stagedModifications'] = self.staged_modifications.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in identifiers (list)
        _items = []
        if self.identifiers:
            for _item in self.identifiers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['identifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item in self.fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relationships (list)
        _items = []
        if self.relationships:
            for _item in self.relationships:
                if _item:
                    _items.append(_item.to_dict())
            _dict['relationships'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CustomEntityResponse:
        """Create an instance of CustomEntityResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CustomEntityResponse.parse_obj(obj)

        _obj = CustomEntityResponse.parse_obj({
            "href": obj.get("href"),
            "entity_type": obj.get("entityType"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "staged_modifications": StagedModificationsInfo.from_dict(obj.get("stagedModifications")) if obj.get("stagedModifications") is not None else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "identifiers": [CustomEntityId.from_dict(_item) for _item in obj.get("identifiers")] if obj.get("identifiers") is not None else None,
            "fields": [CustomEntityField.from_dict(_item) for _item in obj.get("fields")] if obj.get("fields") is not None else None,
            "relationships": [Relationship.from_dict(_item) for _item in obj.get("relationships")] if obj.get("relationships") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
