# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, constr 

class PropertyReferenceDataValue(BaseModel):
    """
    The ReferenceData relevant to the property. The ReferenceData is taken from the DataType on the PropertyDefinition that defines the Property.  Only ReferenceData where the ReferenceData value matches the Property value is included.  # noqa: E501
    """
    string_value:  Optional[StrictStr] = Field(None,alias="stringValue") 
    numeric_value: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="numericValue")
    __properties = ["stringValue", "numericValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PropertyReferenceDataValue:
        """Create an instance of PropertyReferenceDataValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if string_value (nullable) is None
        # and __fields_set__ contains the field
        if self.string_value is None and "string_value" in self.__fields_set__:
            _dict['stringValue'] = None

        # set to None if numeric_value (nullable) is None
        # and __fields_set__ contains the field
        if self.numeric_value is None and "numeric_value" in self.__fields_set__:
            _dict['numericValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PropertyReferenceDataValue:
        """Create an instance of PropertyReferenceDataValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PropertyReferenceDataValue.parse_obj(obj)

        _obj = PropertyReferenceDataValue.parse_obj({
            "string_value": obj.get("stringValue"),
            "numeric_value": obj.get("numericValue")
        })
        return _obj
