# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr 
from lusid.models.label_value_set import LabelValueSet
from lusid.models.metric_value import MetricValue

class PropertyValue(BaseModel):
    """
    The value of the property.  # noqa: E501
    """
    label_value:  Optional[StrictStr] = Field(None,alias="labelValue", description="The text value of a property defined as having the 'Label' type.") 
    metric_value: Optional[MetricValue] = Field(None, alias="metricValue")
    label_value_set: Optional[LabelValueSet] = Field(None, alias="labelValueSet")
    __properties = ["labelValue", "metricValue", "labelValueSet"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PropertyValue:
        """Create an instance of PropertyValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of metric_value
        if self.metric_value:
            _dict['metricValue'] = self.metric_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of label_value_set
        if self.label_value_set:
            _dict['labelValueSet'] = self.label_value_set.to_dict()
        # set to None if label_value (nullable) is None
        # and __fields_set__ contains the field
        if self.label_value is None and "label_value" in self.__fields_set__:
            _dict['labelValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PropertyValue:
        """Create an instance of PropertyValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PropertyValue.parse_obj(obj)

        _obj = PropertyValue.parse_obj({
            "label_value": obj.get("labelValue"),
            "metric_value": MetricValue.from_dict(obj.get("metricValue")) if obj.get("metricValue") is not None else None,
            "label_value_set": LabelValueSet.from_dict(obj.get("labelValueSet")) if obj.get("labelValueSet") is not None else None
        })
        return _obj
