# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, StrictStr, constr 

class SettlementInstructionRequest(BaseModel):
    """
    SettlementInstructionRequest
    """
    settlement_instruction_id:  StrictStr = Field(...,alias="settlementInstructionId") 
    transaction_id:  StrictStr = Field(...,alias="transactionId") 
    settlement_category:  StrictStr = Field(...,alias="settlementCategory") 
    instruction_type:  Optional[StrictStr] = Field(None,alias="instructionType") 
    instrument_identifiers: Dict[str, StrictStr] = Field(..., alias="instrumentIdentifiers")
    contractual_settlement_date: Optional[datetime] = Field(None, alias="contractualSettlementDate")
    actual_settlement_date: datetime = Field(..., alias="actualSettlementDate")
    units: Union[StrictFloat, StrictInt] = Field(...)
    __properties = ["settlementInstructionId", "transactionId", "settlementCategory", "instructionType", "instrumentIdentifiers", "contractualSettlementDate", "actualSettlementDate", "units"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SettlementInstructionRequest:
        """Create an instance of SettlementInstructionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if instruction_type (nullable) is None
        # and __fields_set__ contains the field
        if self.instruction_type is None and "instruction_type" in self.__fields_set__:
            _dict['instructionType'] = None

        # set to None if contractual_settlement_date (nullable) is None
        # and __fields_set__ contains the field
        if self.contractual_settlement_date is None and "contractual_settlement_date" in self.__fields_set__:
            _dict['contractualSettlementDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SettlementInstructionRequest:
        """Create an instance of SettlementInstructionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SettlementInstructionRequest.parse_obj(obj)

        _obj = SettlementInstructionRequest.parse_obj({
            "settlement_instruction_id": obj.get("settlementInstructionId"),
            "transaction_id": obj.get("transactionId"),
            "settlement_category": obj.get("settlementCategory"),
            "instruction_type": obj.get("instructionType"),
            "instrument_identifiers": obj.get("instrumentIdentifiers"),
            "contractual_settlement_date": obj.get("contractualSettlementDate"),
            "actual_settlement_date": obj.get("actualSettlementDate"),
            "units": obj.get("units")
        })
        return _obj
