# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, constr 

class TransactionSettlementInstruction(BaseModel):
    """
    TransactionSettlementInstruction
    """
    settlement_instruction_id:  StrictStr = Field(...,alias="settlementInstructionId", description="The instruction identifier. Unique within the portfolio.") 
    instruction_type:  StrictStr = Field(...,alias="instructionType", description="The type of instruction which can be Complete or CancelAutomatic. Complete means that the instruction is intended to completely settle a settlement bucket. CancelAutomatic means that it is intended to cancel Automatic settlement.") 
    actual_settlement_date: datetime = Field(..., alias="actualSettlementDate", description="The date that settlement takes place.")
    units: Union[StrictFloat, StrictInt] = Field(..., description="The number of units for the instruction.")
    transaction_id:  StrictStr = Field(...,alias="transactionId", description="The ID for the transaction being instructed.") 
    settlement_category:  StrictStr = Field(...,alias="settlementCategory", description="A category representing the set of movement types that this instruction applies to.") 
    lusid_instrument_id:  StrictStr = Field(...,alias="lusidInstrumentId", description="The LusidInstrumentId of the instrument being settled.") 
    contractual_settlement_date: Optional[datetime] = Field(None, alias="contractualSettlementDate", description="The contractual settlement date. Used to match the instruction to the correct settlement bucket.")
    __properties = ["settlementInstructionId", "instructionType", "actualSettlementDate", "units", "transactionId", "settlementCategory", "lusidInstrumentId", "contractualSettlementDate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionSettlementInstruction:
        """Create an instance of TransactionSettlementInstruction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if contractual_settlement_date (nullable) is None
        # and __fields_set__ contains the field
        if self.contractual_settlement_date is None and "contractual_settlement_date" in self.__fields_set__:
            _dict['contractualSettlementDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionSettlementInstruction:
        """Create an instance of TransactionSettlementInstruction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionSettlementInstruction.parse_obj(obj)

        _obj = TransactionSettlementInstruction.parse_obj({
            "settlement_instruction_id": obj.get("settlementInstructionId"),
            "instruction_type": obj.get("instructionType"),
            "actual_settlement_date": obj.get("actualSettlementDate"),
            "units": obj.get("units"),
            "transaction_id": obj.get("transactionId"),
            "settlement_category": obj.get("settlementCategory"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "contractual_settlement_date": obj.get("contractualSettlementDate")
        })
        return _obj
