# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field 
from lusid.models.dialect_id import DialectId
from lusid.models.translation_input import TranslationInput
from lusid.models.translation_script_id import TranslationScriptId

class TranslateEntitiesRequest(BaseModel):
    """
    Request to translate financial entities with a specified script stored in LUSID,  specified in the request by its id. The output of the translation is validated against a dialect stored in LUSID,  again specified in the request by its id.  # noqa: E501
    """
    entity_payloads: Dict[str, TranslationInput] = Field(..., alias="entityPayloads", description="Entity payloads to be translated, indexed by (ephemeral) unique correlation ids.")
    script_id: TranslationScriptId = Field(..., alias="scriptId")
    dialect_id: Optional[DialectId] = Field(None, alias="dialectId")
    __properties = ["entityPayloads", "scriptId", "dialectId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TranslateEntitiesRequest:
        """Create an instance of TranslateEntitiesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in entity_payloads (dict)
        _field_dict = {}
        if self.entity_payloads:
            for _key in self.entity_payloads:
                if self.entity_payloads[_key]:
                    _field_dict[_key] = self.entity_payloads[_key].to_dict()
            _dict['entityPayloads'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of script_id
        if self.script_id:
            _dict['scriptId'] = self.script_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dialect_id
        if self.dialect_id:
            _dict['dialectId'] = self.dialect_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TranslateEntitiesRequest:
        """Create an instance of TranslateEntitiesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TranslateEntitiesRequest.parse_obj(obj)

        _obj = TranslateEntitiesRequest.parse_obj({
            "entity_payloads": dict(
                (_k, TranslationInput.from_dict(_v))
                for _k, _v in obj.get("entityPayloads").items()
            )
            if obj.get("entityPayloads") is not None
            else None,
            "script_id": TranslationScriptId.from_dict(obj.get("scriptId")) if obj.get("scriptId") is not None else None,
            "dialect_id": DialectId.from_dict(obj.get("dialectId")) if obj.get("dialectId") is not None else None
        })
        return _obj
