# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist 
from lusid.models.field_definition import FieldDefinition
from lusid.models.field_value import FieldValue

class UpdateReferenceDataRequest(BaseModel):
    """
    UpdateReferenceDataRequest
    """
    request_definitions: conlist(FieldDefinition) = Field(..., alias="requestDefinitions", description="Definition of a reference data field.")
    request_values: conlist(FieldValue) = Field(..., alias="requestValues", description="Reference data.")
    __properties = ["requestDefinitions", "requestValues"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateReferenceDataRequest:
        """Create an instance of UpdateReferenceDataRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in request_definitions (list)
        _items = []
        if self.request_definitions:
            for _item in self.request_definitions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['requestDefinitions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in request_values (list)
        _items = []
        if self.request_values:
            for _item in self.request_values:
                if _item:
                    _items.append(_item.to_dict())
            _dict['requestValues'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateReferenceDataRequest:
        """Create an instance of UpdateReferenceDataRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateReferenceDataRequest.parse_obj(obj)

        _obj = UpdateReferenceDataRequest.parse_obj({
            "request_definitions": [FieldDefinition.from_dict(_item) for _item in obj.get("requestDefinitions")] if obj.get("requestDefinitions") is not None else None,
            "request_values": [FieldValue.from_dict(_item) for _item in obj.get("requestValues")] if obj.get("requestValues") is not None else None
        })
        return _obj
