# RiskLabAI.py
[![PyPI version](https://badge.fury.io/py/RiskLabAI.svg)](https://badge.fury.io/py/RiskLabAI)

A Python library for quantitative finance and financial AI, implementing core concepts from Marcos López de Prado's books, "Advances in Financial Machine Learning" and "Machine Learning for Asset Managers."

This library provides production-ready implementations for:
* Advanced Financial Data Structures (Tick, Volume, Dollar, Imbalance, and Run Bars)
* Fractional Differentiation (FFD)
* The Triple-Barrier Method and Meta-Labeling
* Advanced Cross-Validation (Purged K-Fold, Combinatorial Purged CV)
* Feature Importance (MDI, MDA, SFI) and Clustered Feature Importance
* Portfolio Optimization (HRP, NCO)
* And many more...

## 📦 Installation

Install the library directly from PyPI:

```bash
pip install RiskLabAI