
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.util
import jpype
import jneqsim.neqsim.blackoil.io
import jneqsim.neqsim.thermo.system
import typing



class BlackOilConverter:
    def __init__(self): ...
    @staticmethod
    def convert(systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], double3: float, double4: float) -> 'BlackOilConverter.Result': ...
    class Result:
        pvt: 'BlackOilPVTTable' = ...
        blackOilSystem: 'SystemBlackOil' = ...
        rho_o_sc: float = ...
        rho_g_sc: float = ...
        rho_w_sc: float = ...
        bubblePoint: float = ...
        def __init__(self): ...

class BlackOilFlash:
    def __init__(self, blackOilPVTTable: 'BlackOilPVTTable', double: float, double2: float, double3: float): ...
    def flash(self, double: float, double2: float, double3: float, double4: float, double5: float) -> 'BlackOilFlashResult': ...

class BlackOilFlashResult:
    O_std: float = ...
    Gf_std: float = ...
    W_std: float = ...
    V_o: float = ...
    V_g: float = ...
    V_w: float = ...
    rho_o: float = ...
    rho_g: float = ...
    rho_w: float = ...
    mu_o: float = ...
    mu_g: float = ...
    mu_w: float = ...
    Rs: float = ...
    Rv: float = ...
    Bo: float = ...
    Bg: float = ...
    Bw: float = ...
    def __init__(self): ...

class BlackOilPVTTable:
    def __init__(self, list: java.util.List['BlackOilPVTTable.Record'], double: float): ...
    def Bg(self, double: float) -> float: ...
    def Bo(self, double: float) -> float: ...
    def Bw(self, double: float) -> float: ...
    def Rs(self, double: float) -> float: ...
    def RsEffective(self, double: float) -> float: ...
    def Rv(self, double: float) -> float: ...
    def getBubblePointP(self) -> float: ...
    def mu_g(self, double: float) -> float: ...
    def mu_o(self, double: float) -> float: ...
    def mu_w(self, double: float) -> float: ...
    class Record:
        p: float = ...
        Rs: float = ...
        Bo: float = ...
        mu_o: float = ...
        Bg: float = ...
        mu_g: float = ...
        Rv: float = ...
        Bw: float = ...
        mu_w: float = ...
        def __init__(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float, double9: float): ...

class SystemBlackOil:
    def __init__(self, blackOilPVTTable: BlackOilPVTTable, double: float, double2: float, double3: float): ...
    def copyShallow(self) -> 'SystemBlackOil': ...
    def flash(self) -> BlackOilFlashResult: ...
    def getBg(self) -> float: ...
    def getBo(self) -> float: ...
    def getBw(self) -> float: ...
    def getGasDensity(self) -> float: ...
    def getGasReservoirVolume(self) -> float: ...
    def getGasStdTotal(self) -> float: ...
    def getGasViscosity(self) -> float: ...
    def getOilDensity(self) -> float: ...
    def getOilReservoirVolume(self) -> float: ...
    def getOilStdTotal(self) -> float: ...
    def getOilViscosity(self) -> float: ...
    def getPressure(self) -> float: ...
    def getRs(self) -> float: ...
    def getRv(self) -> float: ...
    def getTemperature(self) -> float: ...
    def getWaterDensity(self) -> float: ...
    def getWaterReservoirVolume(self) -> float: ...
    def getWaterStd(self) -> float: ...
    def getWaterViscosity(self) -> float: ...
    def setPressure(self, double: float) -> None: ...
    def setStdTotals(self, double: float, double2: float, double3: float) -> None: ...
    def setTemperature(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.blackoil")``.

    BlackOilConverter: typing.Type[BlackOilConverter]
    BlackOilFlash: typing.Type[BlackOilFlash]
    BlackOilFlashResult: typing.Type[BlackOilFlashResult]
    BlackOilPVTTable: typing.Type[BlackOilPVTTable]
    SystemBlackOil: typing.Type[SystemBlackOil]
    io: jneqsim.neqsim.blackoil.io.__module_protocol__
