
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jneqsim.neqsim.chemicalreactions.chemicalequilibrium
import jneqsim.neqsim.chemicalreactions.chemicalreaction
import jneqsim.neqsim.chemicalreactions.kinetics
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.phase
import jneqsim.neqsim.thermo.system
import typing



class ChemicalReactionOperations(jneqsim.neqsim.thermo.ThermodynamicConstantsInterface, java.lang.Cloneable):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def addNewComponents(self) -> None: ...
    def calcBVector(self) -> typing.MutableSequence[float]: ...
    def calcChemRefPot(self, int: int) -> typing.MutableSequence[float]: ...
    def calcInertMoles(self, int: int) -> float: ...
    def calcNVector(self) -> typing.MutableSequence[float]: ...
    def clone(self) -> 'ChemicalReactionOperations': ...
    def getAllElements(self) -> typing.MutableSequence[java.lang.String]: ...
    def getDeltaReactionHeat(self) -> float: ...
    def getKinetics(self) -> jneqsim.neqsim.chemicalreactions.kinetics.Kinetics: ...
    def getReactionList(self) -> jneqsim.neqsim.chemicalreactions.chemicalreaction.ChemicalReactionList: ...
    def hasReactions(self) -> bool: ...
    def reacHeat(self, int: int, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def setComponents(self) -> None: ...
    @typing.overload
    def setComponents(self, int: int) -> None: ...
    def setDeltaReactionHeat(self, double: float) -> None: ...
    @typing.overload
    def setReactiveComponents(self) -> None: ...
    @typing.overload
    def setReactiveComponents(self, int: int) -> None: ...
    def setSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    @typing.overload
    def solveChemEq(self, int: int) -> bool: ...
    @typing.overload
    def solveChemEq(self, int: int, int2: int) -> bool: ...
    def solveKinetics(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int) -> float: ...
    def sortReactiveComponents(self) -> None: ...
    def updateMoles(self, int: int) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.chemicalreactions")``.

    ChemicalReactionOperations: typing.Type[ChemicalReactionOperations]
    chemicalequilibrium: jneqsim.neqsim.chemicalreactions.chemicalequilibrium.__module_protocol__
    chemicalreaction: jneqsim.neqsim.chemicalreactions.chemicalreaction.__module_protocol__
    kinetics: jneqsim.neqsim.chemicalreactions.kinetics.__module_protocol__
