
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.fluidmechanics.flownode.fluidboundary
import jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc
import jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient
import jneqsim.neqsim.fluidmechanics.flownode.multiphasenode
import jneqsim.neqsim.fluidmechanics.flownode.onephasenode
import jneqsim.neqsim.fluidmechanics.flownode.twophasenode
import jneqsim.neqsim.fluidmechanics.geometrydefinitions
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations
import jneqsim.neqsim.util.util
import typing



class FlowNodeInterface(java.lang.Cloneable):
    def calcFluxes(self) -> None: ...
    def calcNusseltNumber(self, double: float, int: int) -> float: ...
    def calcSherwoodNumber(self, double: float, int: int) -> float: ...
    def calcStantonNumber(self, double: float, int: int) -> float: ...
    def calcTotalHeatTransferCoefficient(self, int: int) -> float: ...
    @typing.overload
    def display(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def display(self) -> None: ...
    def getArea(self, int: int) -> float: ...
    def getBulkSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getDistanceToCenterOfNode(self) -> float: ...
    def getEffectiveSchmidtNumber(self, int: int, int2: int) -> float: ...
    def getFlowDirection(self, int: int) -> int: ...
    def getFlowNodeType(self) -> java.lang.String: ...
    def getFluidBoundary(self) -> jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.FluidBoundaryInterface: ...
    def getGeometry(self) -> jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface: ...
    def getHydraulicDiameter(self, int: int) -> float: ...
    def getInterPhaseFrictionFactor(self) -> float: ...
    def getInterphaseContactArea(self) -> float: ...
    def getInterphaseContactLength(self, int: int) -> float: ...
    def getInterphaseSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getInterphaseTransportCoefficient(self) -> jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.InterphaseTransportCoefficientInterface: ...
    def getLengthOfNode(self) -> float: ...
    def getMassFlowRate(self, int: int) -> float: ...
    def getMolarMassTransferRate(self, int: int) -> float: ...
    def getNextNode(self) -> 'FlowNodeInterface': ...
    def getOperations(self) -> jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations: ...
    def getPhaseFraction(self, int: int) -> float: ...
    def getPrandtlNumber(self, int: int) -> float: ...
    @typing.overload
    def getReynoldsNumber(self, int: int) -> float: ...
    @typing.overload
    def getReynoldsNumber(self) -> float: ...
    def getSchmidtNumber(self, int: int, int2: int, int3: int) -> float: ...
    def getSuperficialVelocity(self, int: int) -> float: ...
    @typing.overload
    def getVelocity(self, int: int) -> float: ...
    @typing.overload
    def getVelocity(self) -> float: ...
    @typing.overload
    def getVelocityIn(self, int: int) -> jneqsim.neqsim.util.util.DoubleCloneable: ...
    @typing.overload
    def getVelocityIn(self) -> jneqsim.neqsim.util.util.DoubleCloneable: ...
    @typing.overload
    def getVelocityOut(self, int: int) -> jneqsim.neqsim.util.util.DoubleCloneable: ...
    @typing.overload
    def getVelocityOut(self) -> jneqsim.neqsim.util.util.DoubleCloneable: ...
    def getVerticalPositionOfNode(self) -> float: ...
    def getVolumetricFlow(self) -> float: ...
    def getWallContactLength(self, int: int) -> float: ...
    @typing.overload
    def getWallFrictionFactor(self, int: int) -> float: ...
    @typing.overload
    def getWallFrictionFactor(self) -> float: ...
    def increaseMolarRate(self, double: float) -> None: ...
    def init(self) -> None: ...
    def initBulkSystem(self) -> None: ...
    def initFlowCalc(self) -> None: ...
    def setBulkSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setDistanceToCenterOfNode(self, double: float) -> None: ...
    def setEnhancementType(self, int: int) -> None: ...
    def setFlowDirection(self, int: int, int2: int) -> None: ...
    def setFluxes(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setFrictionFactorType(self, int: int) -> None: ...
    def setGeometryDefinitionInterface(self, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface) -> None: ...
    def setInterphaseModelType(self, int: int) -> None: ...
    def setInterphaseSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setLengthOfNode(self, double: float) -> None: ...
    def setPhaseFraction(self, int: int, double: float) -> None: ...
    @typing.overload
    def setVelocity(self, int: int, double: float) -> None: ...
    @typing.overload
    def setVelocity(self, double: float) -> None: ...
    @typing.overload
    def setVelocityIn(self, int: int, double: float) -> None: ...
    @typing.overload
    def setVelocityIn(self, int: int, doubleCloneable: jneqsim.neqsim.util.util.DoubleCloneable) -> None: ...
    @typing.overload
    def setVelocityIn(self, double: float) -> None: ...
    @typing.overload
    def setVelocityIn(self, doubleCloneable: jneqsim.neqsim.util.util.DoubleCloneable) -> None: ...
    @typing.overload
    def setVelocityOut(self, int: int, double: float) -> None: ...
    @typing.overload
    def setVelocityOut(self, int: int, doubleCloneable: jneqsim.neqsim.util.util.DoubleCloneable) -> None: ...
    @typing.overload
    def setVelocityOut(self, double: float) -> None: ...
    @typing.overload
    def setVelocityOut(self, doubleCloneable: jneqsim.neqsim.util.util.DoubleCloneable) -> None: ...
    def setVerticalPositionOfNode(self, double: float) -> None: ...
    @typing.overload
    def setWallFrictionFactor(self, int: int, double: float) -> None: ...
    @typing.overload
    def setWallFrictionFactor(self, double: float) -> None: ...
    def update(self) -> None: ...
    def updateMolarFlow(self) -> None: ...
    def write(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], boolean: bool) -> None: ...

class FlowNodeSelector:
    def __init__(self): ...
    def getFlowNodeType(self, flowNodeInterfaceArray: typing.Union[typing.List[FlowNodeInterface], jpype.JArray]) -> None: ...
    def setFlowPattern(self, flowNodeInterfaceArray: typing.Union[typing.List[FlowNodeInterface], jpype.JArray], string: typing.Union[java.lang.String, str]) -> None: ...

class FlowNode(FlowNodeInterface, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    molarFlowRate: typing.MutableSequence[float] = ...
    massFlowRate: typing.MutableSequence[float] = ...
    volumetricFlowRate: typing.MutableSequence[float] = ...
    bulkSystem: jneqsim.neqsim.thermo.system.SystemInterface = ...
    velocityIn: typing.MutableSequence[jneqsim.neqsim.util.util.DoubleCloneable] = ...
    velocityOut: typing.MutableSequence[jneqsim.neqsim.util.util.DoubleCloneable] = ...
    superficialVelocity: typing.MutableSequence[float] = ...
    interphaseContactArea: float = ...
    velocity: typing.MutableSequence[float] = ...
    pipe: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface, double: float, double2: float): ...
    def calcFluxes(self) -> None: ...
    def calcNusseltNumber(self, double: float, int: int) -> float: ...
    def calcSherwoodNumber(self, double: float, int: int) -> float: ...
    def calcStantonNumber(self, double: float, int: int) -> float: ...
    def calcTotalHeatTransferCoefficient(self, int: int) -> float: ...
    def clone(self) -> 'FlowNode': ...
    def createTable(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    @typing.overload
    def display(self) -> None: ...
    @typing.overload
    def display(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getArea(self, int: int) -> float: ...
    def getBulkSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getDistanceToCenterOfNode(self) -> float: ...
    def getEffectiveSchmidtNumber(self, int: int, int2: int) -> float: ...
    def getFlowDirection(self, int: int) -> int: ...
    def getFlowNodeType(self) -> java.lang.String: ...
    def getFluidBoundary(self) -> jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.FluidBoundaryInterface: ...
    def getGeometry(self) -> jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface: ...
    def getHydraulicDiameter(self, int: int) -> float: ...
    def getInterPhaseFrictionFactor(self) -> float: ...
    def getInterphaseContactArea(self) -> float: ...
    def getInterphaseContactLength(self, int: int) -> float: ...
    def getInterphaseSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getInterphaseTransportCoefficient(self) -> jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.InterphaseTransportCoefficientInterface: ...
    def getLengthOfNode(self) -> float: ...
    def getMassFlowRate(self, int: int) -> float: ...
    def getMolarMassTransferRate(self, int: int) -> float: ...
    def getNextNode(self) -> FlowNodeInterface: ...
    def getOperations(self) -> jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations: ...
    def getPhaseFraction(self, int: int) -> float: ...
    def getPrandtlNumber(self, int: int) -> float: ...
    @typing.overload
    def getReynoldsNumber(self) -> float: ...
    @typing.overload
    def getReynoldsNumber(self, int: int) -> float: ...
    def getSchmidtNumber(self, int: int, int2: int, int3: int) -> float: ...
    def getSuperficialVelocity(self, int: int) -> float: ...
    @typing.overload
    def getVelocity(self) -> float: ...
    @typing.overload
    def getVelocity(self, int: int) -> float: ...
    @typing.overload
    def getVelocityIn(self) -> jneqsim.neqsim.util.util.DoubleCloneable: ...
    @typing.overload
    def getVelocityIn(self, int: int) -> jneqsim.neqsim.util.util.DoubleCloneable: ...
    @typing.overload
    def getVelocityOut(self) -> jneqsim.neqsim.util.util.DoubleCloneable: ...
    @typing.overload
    def getVelocityOut(self, int: int) -> jneqsim.neqsim.util.util.DoubleCloneable: ...
    def getVerticalPositionOfNode(self) -> float: ...
    def getVolumetricFlow(self) -> float: ...
    def getWallContactLength(self, int: int) -> float: ...
    @typing.overload
    def getWallFrictionFactor(self) -> float: ...
    @typing.overload
    def getWallFrictionFactor(self, int: int) -> float: ...
    def increaseMolarRate(self, double: float) -> None: ...
    def init(self) -> None: ...
    def initBulkSystem(self) -> None: ...
    def setBulkSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setDistanceToCenterOfNode(self, double: float) -> None: ...
    def setEnhancementType(self, int: int) -> None: ...
    def setFlowDirection(self, int: int, int2: int) -> None: ...
    def setFluxes(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setFrictionFactorType(self, int: int) -> None: ...
    def setGeometryDefinitionInterface(self, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface) -> None: ...
    def setInterphaseModelType(self, int: int) -> None: ...
    def setInterphaseSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setLengthOfNode(self, double: float) -> None: ...
    def setOperations(self, thermodynamicOperations: jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations) -> None: ...
    def setPhaseFraction(self, int: int, double: float) -> None: ...
    @typing.overload
    def setVelocity(self, double: float) -> None: ...
    @typing.overload
    def setVelocity(self, int: int, double: float) -> None: ...
    @typing.overload
    def setVelocityIn(self, double: float) -> None: ...
    @typing.overload
    def setVelocityIn(self, doubleCloneable: jneqsim.neqsim.util.util.DoubleCloneable) -> None: ...
    @typing.overload
    def setVelocityIn(self, int: int, double: float) -> None: ...
    @typing.overload
    def setVelocityIn(self, int: int, doubleCloneable: jneqsim.neqsim.util.util.DoubleCloneable) -> None: ...
    @typing.overload
    def setVelocityOut(self, double: float) -> None: ...
    @typing.overload
    def setVelocityOut(self, doubleCloneable: jneqsim.neqsim.util.util.DoubleCloneable) -> None: ...
    @typing.overload
    def setVelocityOut(self, int: int, double: float) -> None: ...
    @typing.overload
    def setVelocityOut(self, int: int, doubleCloneable: jneqsim.neqsim.util.util.DoubleCloneable) -> None: ...
    def setVerticalPositionOfNode(self, double: float) -> None: ...
    @typing.overload
    def setWallFrictionFactor(self, double: float) -> None: ...
    @typing.overload
    def setWallFrictionFactor(self, int: int, double: float) -> None: ...
    def update(self) -> None: ...
    def updateMolarFlow(self) -> None: ...
    def write(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], boolean: bool) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.flownode")``.

    FlowNode: typing.Type[FlowNode]
    FlowNodeInterface: typing.Type[FlowNodeInterface]
    FlowNodeSelector: typing.Type[FlowNodeSelector]
    fluidboundary: jneqsim.neqsim.fluidmechanics.flownode.fluidboundary.__module_protocol__
    multiphasenode: jneqsim.neqsim.fluidmechanics.flownode.multiphasenode.__module_protocol__
    onephasenode: jneqsim.neqsim.fluidmechanics.flownode.onephasenode.__module_protocol__
    twophasenode: jneqsim.neqsim.fluidmechanics.flownode.twophasenode.__module_protocol__
