
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import jpype
import jneqsim.neqsim.fluidmechanics.flownode
import jneqsim.neqsim.fluidmechanics.flownode.multiphasenode.waxnode
import jneqsim.neqsim.fluidmechanics.flownode.twophasenode
import jneqsim.neqsim.fluidmechanics.geometrydefinitions
import jneqsim.neqsim.thermo.system
import typing



class MultiPhaseFlowNode(jneqsim.neqsim.fluidmechanics.flownode.FlowNode):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    def calcContactLength(self) -> float: ...
    def calcFluxes(self) -> None: ...
    def calcGasLiquidContactArea(self) -> float: ...
    def calcHydraulicDiameter(self) -> float: ...
    def calcReynoldNumber(self) -> float: ...
    def calcWallFrictionFactor(self) -> float: ...
    def clone(self) -> jneqsim.neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode: ...
    def init(self) -> None: ...
    def initFlowCalc(self) -> None: ...
    def initVelocity(self) -> float: ...
    def setFluxes(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def update(self) -> None: ...
    def updateMolarFlow(self) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.flownode.multiphasenode")``.

    MultiPhaseFlowNode: typing.Type[MultiPhaseFlowNode]
    waxnode: jneqsim.neqsim.fluidmechanics.flownode.multiphasenode.waxnode.__module_protocol__
