
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.fluidmechanics.flownode
import jneqsim.neqsim.fluidmechanics.flownode.twophasenode
import jneqsim.neqsim.fluidmechanics.geometrydefinitions
import jneqsim.neqsim.thermo.system
import typing



class AnnularFlow(jneqsim.neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    def calcContactLength(self) -> float: ...
    def clone(self) -> 'AnnularFlow': ...
    def getNextNode(self) -> jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface: ...
    def init(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...

class BubbleFlowNode(jneqsim.neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    def calcContactLength(self) -> float: ...
    def calcGasLiquidContactArea(self) -> float: ...
    def clone(self) -> 'BubbleFlowNode': ...
    def getAverageBubbleDiameter(self) -> float: ...
    def getNextNode(self) -> jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface: ...
    def init(self) -> None: ...
    def initFlowCalc(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def setAverageBubbleDiameter(self, double: float) -> None: ...

class DropletFlowNode(jneqsim.neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    def calcContactLength(self) -> float: ...
    def calcGasLiquidContactArea(self) -> float: ...
    def clone(self) -> 'DropletFlowNode': ...
    def getAverageDropletDiameter(self) -> float: ...
    def getNextNode(self) -> jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface: ...
    def init(self) -> None: ...
    def initFlowCalc(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @staticmethod
    def mainOld(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def setAverageDropletDiameter(self, double: float) -> None: ...

class StratifiedFlowNode(jneqsim.neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface, geometryDefinitionInterface: jneqsim.neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface): ...
    def calcContactLength(self) -> float: ...
    def clone(self) -> 'StratifiedFlowNode': ...
    def getNextNode(self) -> jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface: ...
    def init(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode")``.

    AnnularFlow: typing.Type[AnnularFlow]
    BubbleFlowNode: typing.Type[BubbleFlowNode]
    DropletFlowNode: typing.Type[DropletFlowNode]
    StratifiedFlowNode: typing.Type[StratifiedFlowNode]
