
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry
import jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.packings
import jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.wall
import jneqsim.neqsim.fluidmechanics.geometrydefinitions.pipe
import jneqsim.neqsim.fluidmechanics.geometrydefinitions.reactor
import jneqsim.neqsim.fluidmechanics.geometrydefinitions.stirredcell
import jneqsim.neqsim.fluidmechanics.geometrydefinitions.surrounding
import jneqsim.neqsim.thermo
import typing



class GeometryDefinitionInterface(java.lang.Cloneable):
    def clone(self) -> 'GeometryDefinitionInterface': ...
    def getArea(self) -> float: ...
    def getCircumference(self) -> float: ...
    def getDiameter(self) -> float: ...
    def getGeometry(self) -> 'GeometryDefinitionInterface': ...
    def getInnerSurfaceRoughness(self) -> float: ...
    def getInnerWallTemperature(self) -> float: ...
    def getNodeLength(self) -> float: ...
    def getPacking(self) -> jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.packings.PackingInterface: ...
    def getRadius(self) -> float: ...
    @typing.overload
    def getRelativeRoughnes(self) -> float: ...
    @typing.overload
    def getRelativeRoughnes(self, double: float) -> float: ...
    def getSurroundingEnvironment(self) -> jneqsim.neqsim.fluidmechanics.geometrydefinitions.surrounding.SurroundingEnvironment: ...
    def getWallHeatTransferCoefficient(self) -> float: ...
    def init(self) -> None: ...
    def setDiameter(self, double: float) -> None: ...
    def setInnerSurfaceRoughness(self, double: float) -> None: ...
    def setInnerWallTemperature(self, double: float) -> None: ...
    def setNodeLength(self, double: float) -> None: ...
    @typing.overload
    def setPackingType(self, int: int) -> None: ...
    @typing.overload
    def setPackingType(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    def setSurroundingEnvironment(self, surroundingEnvironment: jneqsim.neqsim.fluidmechanics.geometrydefinitions.surrounding.SurroundingEnvironment) -> None: ...
    def setWallHeatTransferCoefficient(self, double: float) -> None: ...

class GeometryDefinition(GeometryDefinitionInterface, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    diameter: float = ...
    radius: float = ...
    innerSurfaceRoughness: float = ...
    nodeLength: float = ...
    area: float = ...
    relativeRoughnes: float = ...
    layerConductivity: typing.MutableSequence[float] = ...
    layerThickness: typing.MutableSequence[float] = ...
    wall: jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.wall.Wall = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    def clone(self) -> GeometryDefinitionInterface: ...
    def getArea(self) -> float: ...
    def getCircumference(self) -> float: ...
    def getDiameter(self) -> float: ...
    def getGeometry(self) -> GeometryDefinitionInterface: ...
    def getInnerSurfaceRoughness(self) -> float: ...
    def getInnerWallTemperature(self) -> float: ...
    def getNodeLength(self) -> float: ...
    def getPacking(self) -> jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.packings.PackingInterface: ...
    def getRadius(self) -> float: ...
    @typing.overload
    def getRelativeRoughnes(self) -> float: ...
    @typing.overload
    def getRelativeRoughnes(self, double: float) -> float: ...
    def getSurroundingEnvironment(self) -> jneqsim.neqsim.fluidmechanics.geometrydefinitions.surrounding.SurroundingEnvironment: ...
    def getWall(self) -> jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.wall.Wall: ...
    def getWallHeatTransferCoefficient(self) -> float: ...
    def init(self) -> None: ...
    def setDiameter(self, double: float) -> None: ...
    def setInnerSurfaceRoughness(self, double: float) -> None: ...
    def setInnerWallTemperature(self, double: float) -> None: ...
    def setNodeLength(self, double: float) -> None: ...
    @typing.overload
    def setPackingType(self, int: int) -> None: ...
    @typing.overload
    def setPackingType(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    def setSurroundingEnvironment(self, surroundingEnvironment: jneqsim.neqsim.fluidmechanics.geometrydefinitions.surrounding.SurroundingEnvironment) -> None: ...
    def setWall(self, wall: jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.wall.Wall) -> None: ...
    def setWallHeatTransferCoefficient(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.geometrydefinitions")``.

    GeometryDefinition: typing.Type[GeometryDefinition]
    GeometryDefinitionInterface: typing.Type[GeometryDefinitionInterface]
    internalgeometry: jneqsim.neqsim.fluidmechanics.geometrydefinitions.internalgeometry.__module_protocol__
    pipe: jneqsim.neqsim.fluidmechanics.geometrydefinitions.pipe.__module_protocol__
    reactor: jneqsim.neqsim.fluidmechanics.geometrydefinitions.reactor.__module_protocol__
    stirredcell: jneqsim.neqsim.fluidmechanics.geometrydefinitions.stirredcell.__module_protocol__
    surrounding: jneqsim.neqsim.fluidmechanics.geometrydefinitions.surrounding.__module_protocol__
