
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import jneqsim.neqsim.fluidmechanics.flownode
import jneqsim.neqsim.fluidmechanics.util.fluidmechanicsvisualization.flownodevisualization.onephaseflownodevisualization
import jneqsim.neqsim.fluidmechanics.util.fluidmechanicsvisualization.flownodevisualization.twophaseflownodevisualization
import typing



class FlowNodeVisualizationInterface:
    def getBulkComposition(self, int: int, int2: int) -> float: ...
    def getDistanceToCenterOfNode(self) -> float: ...
    def getEffectiveMassTransferCoefficient(self, int: int, int2: int) -> float: ...
    def getEffectiveSchmidtNumber(self, int: int, int2: int) -> float: ...
    def getInterfaceComposition(self, int: int, int2: int) -> float: ...
    def getInterfaceTemperature(self, int: int) -> float: ...
    def getInterphaseContactLength(self) -> float: ...
    def getMolarFlux(self, int: int, int2: int) -> float: ...
    def getNumberOfComponents(self) -> int: ...
    def getPhaseFraction(self, int: int) -> float: ...
    def getPressure(self, int: int) -> float: ...
    def getReynoldsNumber(self, int: int) -> float: ...
    def getTemperature(self, int: int) -> float: ...
    def getVelocity(self, int: int) -> float: ...
    def getWallContactLength(self, int: int) -> float: ...
    def setData(self, flowNodeInterface: jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface) -> None: ...

class FlowNodeVisualization(FlowNodeVisualizationInterface):
    temperature: typing.MutableSequence[float] = ...
    reynoldsNumber: typing.MutableSequence[float] = ...
    interfaceTemperature: typing.MutableSequence[float] = ...
    pressure: typing.MutableSequence[float] = ...
    velocity: typing.MutableSequence[float] = ...
    phaseFraction: typing.MutableSequence[float] = ...
    wallContactLength: typing.MutableSequence[float] = ...
    bulkComposition: typing.MutableSequence[typing.MutableSequence[float]] = ...
    interfaceComposition: typing.MutableSequence[typing.MutableSequence[float]] = ...
    effectiveMassTransferCoefficient: typing.MutableSequence[typing.MutableSequence[float]] = ...
    effectiveSchmidtNumber: typing.MutableSequence[typing.MutableSequence[float]] = ...
    molarFlux: typing.MutableSequence[typing.MutableSequence[float]] = ...
    interphaseContactLength: float = ...
    nodeCenter: float = ...
    numberOfComponents: int = ...
    def __init__(self): ...
    def getBulkComposition(self, int: int, int2: int) -> float: ...
    def getDistanceToCenterOfNode(self) -> float: ...
    def getEffectiveMassTransferCoefficient(self, int: int, int2: int) -> float: ...
    def getEffectiveSchmidtNumber(self, int: int, int2: int) -> float: ...
    def getInterfaceComposition(self, int: int, int2: int) -> float: ...
    def getInterfaceTemperature(self, int: int) -> float: ...
    def getInterphaseContactLength(self) -> float: ...
    def getMolarFlux(self, int: int, int2: int) -> float: ...
    def getNumberOfComponents(self) -> int: ...
    def getPhaseFraction(self, int: int) -> float: ...
    def getPressure(self, int: int) -> float: ...
    def getReynoldsNumber(self, int: int) -> float: ...
    def getTemperature(self, int: int) -> float: ...
    def getVelocity(self, int: int) -> float: ...
    def getWallContactLength(self, int: int) -> float: ...
    def setData(self, flowNodeInterface: jneqsim.neqsim.fluidmechanics.flownode.FlowNodeInterface) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.fluidmechanics.util.fluidmechanicsvisualization.flownodevisualization")``.

    FlowNodeVisualization: typing.Type[FlowNodeVisualization]
    FlowNodeVisualizationInterface: typing.Type[FlowNodeVisualizationInterface]
    onephaseflownodevisualization: jneqsim.neqsim.fluidmechanics.util.fluidmechanicsvisualization.flownodevisualization.onephaseflownodevisualization.__module_protocol__
    twophaseflownodevisualization: jneqsim.neqsim.fluidmechanics.util.fluidmechanicsvisualization.flownodevisualization.twophaseflownodevisualization.__module_protocol__
