
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import jneqsim.neqsim.physicalproperties.methods.commonphasephysicalproperties
import jneqsim.neqsim.physicalproperties.methods.methodinterface
import jneqsim.neqsim.physicalproperties.system
import jneqsim.neqsim.thermo
import typing



class Viscosity(jneqsim.neqsim.physicalproperties.methods.commonphasephysicalproperties.CommonPhysicalPropertyMethod, jneqsim.neqsim.physicalproperties.methods.methodinterface.ViscosityInterface):
    pureComponentViscosity: typing.MutableSequence[float] = ...
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcPureComponentViscosity(self) -> None: ...
    def clone(self) -> 'Viscosity': ...
    def getPureComponentViscosity(self, int: int) -> float: ...
    def getViscosityPressureCorrection(self, int: int) -> float: ...

class CO2ViscosityMethod(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...

class FrictionTheoryViscosityMethod(Viscosity, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    pureComponentViscosity: typing.MutableSequence[float] = ...
    Fc: typing.MutableSequence[float] = ...
    omegaVisc: typing.MutableSequence[float] = ...
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...
    def getPureComponentViscosity(self, int: int) -> float: ...
    def getRedKapa(self, int: int, double: float, double2: float) -> float: ...
    def getRedKapr(self, int: int, double: float, double2: float) -> float: ...
    def getRedKaprr(self, int: int, double: float, double2: float) -> float: ...
    def getTBPviscosityCorrection(self) -> float: ...
    def initChungPureComponentViscosity(self) -> None: ...
    def setTBPviscosityCorrection(self, double: float) -> None: ...
    def tuneModel(self, double: float, double2: float, double3: float) -> None: ...

class KTAViscosityMethod(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...

class KTAViscosityMethodMod(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...

class LBCViscosityMethod(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...
    def getPureComponentViscosity(self, int: int) -> float: ...

class MethaneViscosityMethod(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...

class MuznyModViscosityMethod(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...

class MuznyViscosityMethod(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...

class PFCTViscosityMethod(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...
    def getPureComponentViscosity(self, int: int) -> float: ...
    def getRefComponentViscosity(self, double: float, double2: float) -> float: ...

class PFCTViscosityMethodHeavyOil(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...
    def getRefComponentViscosity(self, double: float, double2: float) -> float: ...

class PFCTViscosityMethodMod86(Viscosity):
    def __init__(self, physicalProperties: jneqsim.neqsim.physicalproperties.system.PhysicalProperties): ...
    def calcViscosity(self) -> float: ...
    def getRefComponentViscosity(self, double: float, double2: float) -> float: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity")``.

    CO2ViscosityMethod: typing.Type[CO2ViscosityMethod]
    FrictionTheoryViscosityMethod: typing.Type[FrictionTheoryViscosityMethod]
    KTAViscosityMethod: typing.Type[KTAViscosityMethod]
    KTAViscosityMethodMod: typing.Type[KTAViscosityMethodMod]
    LBCViscosityMethod: typing.Type[LBCViscosityMethod]
    MethaneViscosityMethod: typing.Type[MethaneViscosityMethod]
    MuznyModViscosityMethod: typing.Type[MuznyModViscosityMethod]
    MuznyViscosityMethod: typing.Type[MuznyViscosityMethod]
    PFCTViscosityMethod: typing.Type[PFCTViscosityMethod]
    PFCTViscosityMethodHeavyOil: typing.Type[PFCTViscosityMethodHeavyOil]
    PFCTViscosityMethodMod86: typing.Type[PFCTViscosityMethodMod86]
    Viscosity: typing.Type[Viscosity]
