
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.phase
import typing



class PhysicalPropertyMixingRuleInterface(java.lang.Cloneable):
    def clone(self) -> 'PhysicalPropertyMixingRuleInterface': ...
    def getViscosityGij(self, int: int, int2: int) -> float: ...
    def initMixingRules(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def setViscosityGij(self, double: float, int: int, int2: int) -> None: ...

class PhysicalPropertyMixingRule(PhysicalPropertyMixingRuleInterface, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    Gij: typing.MutableSequence[typing.MutableSequence[float]] = ...
    def __init__(self): ...
    def clone(self) -> 'PhysicalPropertyMixingRule': ...
    def getPhysicalPropertyMixingRule(self) -> PhysicalPropertyMixingRuleInterface: ...
    def getViscosityGij(self, int: int, int2: int) -> float: ...
    def initMixingRules(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def setViscosityGij(self, double: float, int: int, int2: int) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.physicalproperties.mixingrule")``.

    PhysicalPropertyMixingRule: typing.Type[PhysicalPropertyMixingRule]
    PhysicalPropertyMixingRuleInterface: typing.Type[PhysicalPropertyMixingRuleInterface]
