
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.physicalproperties
import jneqsim.neqsim.physicalproperties.methods.methodinterface
import jneqsim.neqsim.physicalproperties.mixingrule
import jneqsim.neqsim.physicalproperties.system.commonphasephysicalproperties
import jneqsim.neqsim.physicalproperties.system.gasphysicalproperties
import jneqsim.neqsim.physicalproperties.system.liquidphysicalproperties
import jneqsim.neqsim.physicalproperties.system.solidphysicalproperties
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.phase
import typing



class PhysicalProperties(java.lang.Cloneable, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    conductivityCalc: jneqsim.neqsim.physicalproperties.methods.methodinterface.ConductivityInterface = ...
    viscosityCalc: jneqsim.neqsim.physicalproperties.methods.methodinterface.ViscosityInterface = ...
    diffusivityCalc: jneqsim.neqsim.physicalproperties.methods.methodinterface.DiffusivityInterface = ...
    densityCalc: jneqsim.neqsim.physicalproperties.methods.methodinterface.DensityInterface = ...
    kinematicViscosity: float = ...
    density: float = ...
    viscosity: float = ...
    conductivity: float = ...
    @typing.overload
    def __init__(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface): ...
    @typing.overload
    def __init__(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int): ...
    def calcDensity(self) -> float: ...
    def calcEffectiveDiffusionCoefficients(self) -> None: ...
    def calcKinematicViscosity(self) -> float: ...
    def clone(self) -> 'PhysicalProperties': ...
    def getConductivity(self) -> float: ...
    def getConductivityModel(self) -> jneqsim.neqsim.physicalproperties.methods.methodinterface.ConductivityInterface: ...
    def getDensity(self) -> float: ...
    @typing.overload
    def getDiffusionCoefficient(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getDiffusionCoefficient(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEffectiveDiffusionCoefficient(self, int: int) -> float: ...
    @typing.overload
    def getEffectiveDiffusionCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEffectiveSchmidtNumber(self, int: int) -> float: ...
    def getFickDiffusionCoefficient(self, int: int, int2: int) -> float: ...
    def getKinematicViscosity(self) -> float: ...
    def getMixingRule(self) -> jneqsim.neqsim.physicalproperties.mixingrule.PhysicalPropertyMixingRuleInterface: ...
    def getPhase(self) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getPureComponentViscosity(self, int: int) -> float: ...
    def getViscosity(self) -> float: ...
    def getViscosityModel(self) -> jneqsim.neqsim.physicalproperties.methods.methodinterface.ViscosityInterface: ...
    def getViscosityOfWaxyOil(self, double: float, double2: float) -> float: ...
    def getWaxViscosityParameter(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def init(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    @typing.overload
    def init(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def init(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, physicalPropertyType: jneqsim.neqsim.physicalproperties.PhysicalPropertyType) -> None: ...
    def setBinaryDiffusionCoefficientMethod(self, int: int) -> None: ...
    def setConductivityModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDensityModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDiffusionCoefficientModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMixingRule(self, physicalPropertyMixingRuleInterface: jneqsim.neqsim.physicalproperties.mixingrule.PhysicalPropertyMixingRuleInterface) -> None: ...
    def setMixingRuleNull(self) -> None: ...
    def setMulticomponentDiffusionMethod(self, int: int) -> None: ...
    def setPhase(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def setPhases(self) -> None: ...
    def setViscosityModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setWaxViscosityParameter(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setWaxViscosityParameter(self, int: int, double: float) -> None: ...

class PhysicalPropertyModel(java.lang.Enum['PhysicalPropertyModel']):
    DEFAULT: typing.ClassVar['PhysicalPropertyModel'] = ...
    WATER: typing.ClassVar['PhysicalPropertyModel'] = ...
    GLYCOL: typing.ClassVar['PhysicalPropertyModel'] = ...
    AMINE: typing.ClassVar['PhysicalPropertyModel'] = ...
    CO2WATER: typing.ClassVar['PhysicalPropertyModel'] = ...
    BASIC: typing.ClassVar['PhysicalPropertyModel'] = ...
    SALT_WATER: typing.ClassVar['PhysicalPropertyModel'] = ...
    @staticmethod
    def byName(string: typing.Union[java.lang.String, str]) -> 'PhysicalPropertyModel': ...
    @staticmethod
    def byValue(int: int) -> 'PhysicalPropertyModel': ...
    def getValue(self) -> int: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'PhysicalPropertyModel': ...
    @staticmethod
    def values() -> typing.MutableSequence['PhysicalPropertyModel']: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.physicalproperties.system")``.

    PhysicalProperties: typing.Type[PhysicalProperties]
    PhysicalPropertyModel: typing.Type[PhysicalPropertyModel]
    commonphasephysicalproperties: jneqsim.neqsim.physicalproperties.system.commonphasephysicalproperties.__module_protocol__
    gasphysicalproperties: jneqsim.neqsim.physicalproperties.system.gasphysicalproperties.__module_protocol__
    liquidphysicalproperties: jneqsim.neqsim.physicalproperties.system.liquidphysicalproperties.__module_protocol__
    solidphysicalproperties: jneqsim.neqsim.physicalproperties.system.solidphysicalproperties.__module_protocol__
