
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import jneqsim.neqsim.process.controllerdevice
import jneqsim.neqsim.process.measurementdevice
import typing



class ControlStructureInterface(java.io.Serializable):
    def getOutput(self) -> float: ...
    def isActive(self) -> bool: ...
    def runTransient(self, double: float) -> None: ...
    def setActive(self, boolean: bool) -> None: ...

class CascadeControllerStructure(ControlStructureInterface):
    def __init__(self, controllerDeviceInterface: jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface, controllerDeviceInterface2: jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface): ...
    def getOutput(self) -> float: ...
    def isActive(self) -> bool: ...
    def runTransient(self, double: float) -> None: ...
    def setActive(self, boolean: bool) -> None: ...

class FeedForwardControllerStructure(ControlStructureInterface):
    def __init__(self, controllerDeviceInterface: jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface, measurementDeviceInterface: jneqsim.neqsim.process.measurementdevice.MeasurementDeviceInterface): ...
    def getOutput(self) -> float: ...
    def isActive(self) -> bool: ...
    def runTransient(self, double: float) -> None: ...
    def setActive(self, boolean: bool) -> None: ...
    def setFeedForwardGain(self, double: float) -> None: ...

class RatioControllerStructure(ControlStructureInterface):
    def __init__(self, controllerDeviceInterface: jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface, measurementDeviceInterface: jneqsim.neqsim.process.measurementdevice.MeasurementDeviceInterface): ...
    def getOutput(self) -> float: ...
    def isActive(self) -> bool: ...
    def runTransient(self, double: float) -> None: ...
    def setActive(self, boolean: bool) -> None: ...
    def setRatio(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.controllerdevice.structure")``.

    CascadeControllerStructure: typing.Type[CascadeControllerStructure]
    ControlStructureInterface: typing.Type[ControlStructureInterface]
    FeedForwardControllerStructure: typing.Type[FeedForwardControllerStructure]
    RatioControllerStructure: typing.Type[RatioControllerStructure]
