
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.separator
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.mechanicaldesign.absorber
import typing



class AbsorberInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def setAproachToEquilibrium(self, double: float) -> None: ...

class SimpleAbsorber(jneqsim.neqsim.process.equipment.separator.Separator, AbsorberInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getFsFactor(self) -> float: ...
    def getHTU(self) -> float: ...
    def getInStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getInTemperature(self, int: int) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.absorber.AbsorberMechanicalDesign: ...
    def getNTU(self) -> float: ...
    def getNumberOfStages(self) -> int: ...
    def getNumberOfTheoreticalStages(self) -> float: ...
    @typing.overload
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getOutStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutTemperature(self, int: int) -> float: ...
    def getSolventInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getStageEfficiency(self) -> float: ...
    def getWettingRate(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setAproachToEquilibrium(self, double: float) -> None: ...
    def setHTU(self, double: float) -> None: ...
    def setNTU(self, double: float) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setNumberOfStages(self, int: int) -> None: ...
    def setNumberOfTheoreticalStages(self, double: float) -> None: ...
    def setOutTemperature(self, double: float) -> None: ...
    def setStageEfficiency(self, double: float) -> None: ...
    def setdT(self, double: float) -> None: ...

class SimpleTEGAbsorber(SimpleAbsorber):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addGasInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def addSolventInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def addStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcEa(self) -> float: ...
    def calcMixStreamEnthalpy(self) -> float: ...
    def calcNTU(self, double: float, double2: float, double3: float, double4: float) -> float: ...
    def calcNumberOfTheoreticalStages(self) -> float: ...
    def calcY0(self) -> float: ...
    def displayResult(self) -> None: ...
    def getGasInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getGasLoadFactor(self) -> float: ...
    @typing.overload
    def getGasLoadFactor(self, int: int) -> float: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getInStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getOutStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getSolventInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getSolventOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def guessTemperature(self) -> float: ...
    def isSetWaterInDryGas(self, boolean: bool) -> None: ...
    def mixStream(self) -> None: ...
    def replaceSolventInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runConditionAnalysis(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    def setGasOutStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setSolventOutStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setWaterInDryGas(self, double: float) -> None: ...

class WaterStripperColumn(SimpleAbsorber):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addGasInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def addSolventInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def addStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcEa(self) -> float: ...
    def calcMixStreamEnthalpy(self) -> float: ...
    def calcNTU(self, double: float, double2: float, double3: float, double4: float) -> float: ...
    def calcNumberOfTheoreticalStages(self) -> float: ...
    def calcX0(self) -> float: ...
    def displayResult(self) -> None: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getInStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getOutStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getSolventInStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getSolventOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getWaterDewPointTemperature(self) -> float: ...
    def guessTemperature(self) -> float: ...
    def mixStream(self) -> None: ...
    def replaceSolventInStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setGasOutStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setSolventOutStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setWaterDewPointTemperature(self, double: float, double2: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.absorber")``.

    AbsorberInterface: typing.Type[AbsorberInterface]
    SimpleAbsorber: typing.Type[SimpleAbsorber]
    SimpleTEGAbsorber: typing.Type[SimpleTEGAbsorber]
    WaterStripperColumn: typing.Type[WaterStripperColumn]
