
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.mechanicaldesign.compressor
import jneqsim.neqsim.process.util.report
import jneqsim.neqsim.thermo.system
import typing



class AntiSurge(java.io.Serializable):
    def __init__(self): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getCurrentSurgeFraction(self) -> float: ...
    def getSurgeControlFactor(self) -> float: ...
    def hashCode(self) -> int: ...
    def isActive(self) -> bool: ...
    def isSurge(self) -> bool: ...
    def setActive(self, boolean: bool) -> None: ...
    def setCurrentSurgeFraction(self, double: float) -> None: ...
    def setSurge(self, boolean: bool) -> None: ...
    def setSurgeControlFactor(self, double: float) -> None: ...

class BoundaryCurveInterface(java.io.Serializable):
    def getFlow(self, double: float) -> float: ...
    def isActive(self) -> bool: ...
    def isLimit(self, double: float, double2: float) -> bool: ...
    def setActive(self, boolean: bool) -> None: ...
    def setCurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class CompressorChartGenerator:
    def __init__(self, compressor: 'Compressor'): ...
    def generateCompressorChart(self, string: typing.Union[java.lang.String, str]) -> 'CompressorChart': ...

class CompressorChartInterface(java.lang.Cloneable):
    @typing.overload
    def addCurve(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def addCurve(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def generateStoneWallCurve(self) -> None: ...
    def generateSurgeCurve(self) -> None: ...
    def getFlow(self, double: float, double2: float, double3: float) -> float: ...
    def getHeadUnit(self) -> java.lang.String: ...
    def getMinSpeedCurve(self) -> float: ...
    def getPolytropicEfficiency(self, double: float, double2: float) -> float: ...
    def getPolytropicHead(self, double: float, double2: float) -> float: ...
    def getSpeed(self, double: float, double2: float) -> int: ...
    def getStoneWallCurve(self) -> 'StoneWallCurve': ...
    def getSurgeCurve(self) -> 'SafeSplineSurgeCurve': ...
    def hashCode(self) -> int: ...
    def isUseCompressorChart(self) -> bool: ...
    def plot(self) -> None: ...
    @typing.overload
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray6: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setHeadUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferenceConditions(self, double: float, double2: float, double3: float, double4: float) -> None: ...
    def setStoneWallCurve(self, stoneWallCurve: 'StoneWallCurve') -> None: ...
    def setSurgeCurve(self, safeSplineSurgeCurve: 'SafeSplineSurgeCurve') -> None: ...
    def setUseCompressorChart(self, boolean: bool) -> None: ...
    def setUseRealKappa(self, boolean: bool) -> None: ...
    def useRealKappa(self) -> bool: ...

class CompressorChartReader:
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def getChokeFlow(self) -> typing.MutableSequence[float]: ...
    def getChokeHead(self) -> typing.MutableSequence[float]: ...
    def getFlowLines(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getHeadLines(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getPolyEffLines(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getSpeeds(self) -> typing.MutableSequence[float]: ...
    def getStonewallCurve(self) -> typing.MutableSequence[float]: ...
    def getSurgeCurve(self) -> typing.MutableSequence[float]: ...
    def getSurgeFlow(self) -> typing.MutableSequence[float]: ...
    def getSurgeHead(self) -> typing.MutableSequence[float]: ...
    def setCurvesToCompressor(self, compressor: 'Compressor') -> None: ...
    def setHeadUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...

class CompressorCurve(java.io.Serializable):
    flow: typing.MutableSequence[float] = ...
    flowPolytropicEfficiency: typing.MutableSequence[float] = ...
    head: typing.MutableSequence[float] = ...
    polytropicEfficiency: typing.MutableSequence[float] = ...
    speed: float = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]): ...
    @typing.overload
    def __init__(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray]): ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...

class CompressorInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, jneqsim.neqsim.process.equipment.TwoPortInterface):
    def equals(self, object: typing.Any) -> bool: ...
    def getAntiSurge(self) -> AntiSurge: ...
    def getDistanceToSurge(self) -> float: ...
    def getEnergy(self) -> float: ...
    def getIsentropicEfficiency(self) -> float: ...
    def getMaximumSpeed(self) -> float: ...
    def getMinimumSpeed(self) -> float: ...
    def getPolytropicEfficiency(self) -> float: ...
    def getSurgeFlowRate(self) -> float: ...
    def getSurgeFlowRateMargin(self) -> float: ...
    def hashCode(self) -> int: ...
    def isSurge(self) -> bool: ...
    def setCompressorChartType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setIsentropicEfficiency(self, double: float) -> None: ...
    def setMaximumSpeed(self, double: float) -> None: ...
    def setMinimumSpeed(self, double: float) -> None: ...
    def setPolytropicEfficiency(self, double: float) -> None: ...

class CompressorPropertyProfile(java.io.Serializable):
    def __init__(self): ...
    def addFluid(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def getFluid(self) -> java.util.ArrayList[jneqsim.neqsim.thermo.system.SystemInterface]: ...
    def isActive(self) -> bool: ...
    def setActive(self, boolean: bool) -> None: ...
    def setFluid(self, arrayList: java.util.ArrayList[jneqsim.neqsim.thermo.system.SystemInterface]) -> None: ...

class BoundaryCurve(BoundaryCurveInterface):
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def getFlow(self, double: float) -> float: ...
    @typing.overload
    def getFlow(self) -> typing.MutableSequence[float]: ...
    def getHead(self) -> typing.MutableSequence[float]: ...
    def hashCode(self) -> int: ...
    def isActive(self) -> bool: ...
    def setActive(self, boolean: bool) -> None: ...
    def setCurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class Compressor(jneqsim.neqsim.process.equipment.TwoPortEquipment, CompressorInterface):
    thermoSystem: jneqsim.neqsim.thermo.system.SystemInterface = ...
    dH: float = ...
    inletEnthalpy: float = ...
    pressure: float = ...
    isentropicEfficiency: float = ...
    polytropicEfficiency: float = ...
    usePolytropicCalc: bool = ...
    powerSet: bool = ...
    calcPressureOut: bool = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], boolean: bool): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def copy(self) -> 'Compressor': ...
    def displayResult(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def findOutPressure(self, double: float, double2: float, double3: float) -> float: ...
    def generateCompressorCurves(self) -> None: ...
    def getActualCompressionRatio(self) -> float: ...
    def getAntiSurge(self) -> AntiSurge: ...
    def getCompressionRatio(self) -> float: ...
    def getCompressorChart(self) -> CompressorChartInterface: ...
    def getDistanceToSurge(self) -> float: ...
    def getEnergy(self) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    def getIsentropicEfficiency(self) -> float: ...
    def getMaxOutletPressure(self) -> float: ...
    def getMaximumSpeed(self) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.compressor.CompressorMechanicalDesign: ...
    def getMinimumSpeed(self) -> float: ...
    def getNumberOfCompressorCalcSteps(self) -> int: ...
    def getOutTemperature(self) -> float: ...
    def getOutletPressure(self) -> float: ...
    def getPolytropicEfficiency(self) -> float: ...
    def getPolytropicExponent(self) -> float: ...
    def getPolytropicFluidHead(self) -> float: ...
    @typing.overload
    def getPolytropicHead(self) -> float: ...
    @typing.overload
    def getPolytropicHead(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getPolytropicHeadMeter(self) -> float: ...
    def getPolytropicMethod(self) -> java.lang.String: ...
    @typing.overload
    def getPower(self) -> float: ...
    @typing.overload
    def getPower(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getPropertyProfile(self) -> CompressorPropertyProfile: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSpeed(self) -> float: ...
    def getSurgeFlowRate(self) -> float: ...
    def getSurgeFlowRateMargin(self) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getTotalWork(self) -> float: ...
    def hashCode(self) -> int: ...
    def initMechanicalDesign(self) -> None: ...
    def isCalcPressureOut(self) -> bool: ...
    def isLimitSpeed(self) -> bool: ...
    def isSetMaxOutletPressure(self) -> bool: ...
    def isSolveSpeed(self) -> bool: ...
    def isStoneWall(self, double: float, double2: float) -> bool: ...
    @typing.overload
    def isSurge(self, double: float, double2: float) -> bool: ...
    @typing.overload
    def isSurge(self) -> bool: ...
    def isUseGERG2008(self) -> bool: ...
    def isUseLeachman(self) -> bool: ...
    def isUseRigorousPolytropicMethod(self) -> bool: ...
    def isUseVega(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runController(self, double: float, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setAntiSurge(self, antiSurge: AntiSurge) -> None: ...
    def setCalcPressureOut(self, boolean: bool) -> None: ...
    def setCompressionRatio(self, double: float) -> None: ...
    def setCompressorChart(self, compressorChartInterface: CompressorChartInterface) -> None: ...
    def setCompressorChartType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setIsSetMaxOutletPressure(self, boolean: bool) -> None: ...
    def setIsentropicEfficiency(self, double: float) -> None: ...
    def setLimitSpeed(self, boolean: bool) -> None: ...
    def setMaxOutletPressure(self, double: float) -> None: ...
    def setMaximumSpeed(self, double: float) -> None: ...
    def setMinimumSpeed(self, double: float) -> None: ...
    def setNumberOfCompressorCalcSteps(self, int: int) -> None: ...
    def setOutTemperature(self, double: float) -> None: ...
    @typing.overload
    def setOutletPressure(self, double: float) -> None: ...
    @typing.overload
    def setOutletPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPolytropicEfficiency(self, double: float) -> None: ...
    def setPolytropicHeadMeter(self, double: float) -> None: ...
    def setPolytropicMethod(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPower(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPropertyProfile(self, compressorPropertyProfile: CompressorPropertyProfile) -> None: ...
    def setSolveSpeed(self, boolean: bool) -> None: ...
    def setSpeed(self, double: float) -> None: ...
    def setUseGERG2008(self, boolean: bool) -> None: ...
    def setUseLeachman(self, boolean: bool) -> None: ...
    def setUsePolytropicCalc(self, boolean: bool) -> None: ...
    def setUseRigorousPolytropicMethod(self, boolean: bool) -> None: ...
    def setUseVega(self, boolean: bool) -> None: ...
    def solveAntiSurge(self) -> None: ...
    def solveEfficiency(self, double: float) -> float: ...
    @typing.overload
    def toJson(self) -> java.lang.String: ...
    @typing.overload
    def toJson(self, reportConfig: jneqsim.neqsim.process.util.report.ReportConfig) -> java.lang.String: ...
    def useOutTemperature(self, boolean: bool) -> None: ...
    def usePolytropicCalc(self) -> bool: ...

class CompressorChart(CompressorChartInterface, java.io.Serializable):
    def __init__(self): ...
    @typing.overload
    def addCurve(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def addCurve(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def addSurgeCurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def checkStoneWall(self, double: float, double2: float) -> bool: ...
    def checkSurge1(self, double: float, double2: float) -> bool: ...
    def checkSurge2(self, double: float, double2: float) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def fitReducedCurve(self) -> None: ...
    def generateStoneWallCurve(self) -> None: ...
    def generateSurgeCurve(self) -> None: ...
    def getFlow(self, double: float, double2: float, double3: float) -> float: ...
    def getHeadUnit(self) -> java.lang.String: ...
    def getMaxSpeedCurve(self) -> float: ...
    def getMinSpeedCurve(self) -> float: ...
    def getPolytropicEfficiency(self, double: float, double2: float) -> float: ...
    def getPolytropicHead(self, double: float, double2: float) -> float: ...
    def getSpeed(self, double: float, double2: float) -> int: ...
    def getStoneWallCurve(self) -> 'StoneWallCurve': ...
    def getSurgeCurve(self) -> 'SafeSplineSurgeCurve': ...
    def hashCode(self) -> int: ...
    def isUseCompressorChart(self) -> bool: ...
    def plot(self) -> None: ...
    def polytropicEfficiency(self, double: float, double2: float) -> float: ...
    @typing.overload
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray6: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setHeadUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMaxSpeedCurve(self, double: float) -> None: ...
    def setMinSpeedCurve(self, double: float) -> None: ...
    def setReferenceConditions(self, double: float, double2: float, double3: float, double4: float) -> None: ...
    def setStoneWallCurve(self, stoneWallCurve: 'StoneWallCurve') -> None: ...
    def setSurgeCurve(self, safeSplineSurgeCurve: 'SafeSplineSurgeCurve') -> None: ...
    def setUseCompressorChart(self, boolean: bool) -> None: ...
    def setUseRealKappa(self, boolean: bool) -> None: ...
    def useRealKappa(self) -> bool: ...

class CompressorChartAlternativeMapLookup(CompressorChart, CompressorChartInterface, java.io.Serializable):
    def __init__(self): ...
    @typing.overload
    def addCurve(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def addCurve(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def addSurgeCurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    @staticmethod
    def bisect_left(doubleArray: typing.Union[typing.List[float], jpype.JArray], double2: float) -> int: ...
    @typing.overload
    @staticmethod
    def bisect_left(doubleArray: typing.Union[typing.List[float], jpype.JArray], double2: float, int: int, int2: int) -> int: ...
    def checkStoneWall(self, double: float, double2: float) -> bool: ...
    def checkSurge1(self, double: float, double2: float) -> bool: ...
    def checkSurge2(self, double: float, double2: float) -> bool: ...
    def getChartValues(self) -> java.util.ArrayList[CompressorCurve]: ...
    def getClosestRefSpeeds(self, double: float) -> java.util.ArrayList[float]: ...
    def getCurveAtRefSpeed(self, double: float) -> CompressorCurve: ...
    def getFlow(self, double: float, double2: float, double3: float) -> float: ...
    def getGearRatio(self) -> float: ...
    def getHeadUnit(self) -> java.lang.String: ...
    def getMinSpeedCurve(self) -> float: ...
    def getPolytropicEfficiency(self, double: float, double2: float) -> float: ...
    def getPolytropicHead(self, double: float, double2: float) -> float: ...
    def getSpeed(self, double: float, double2: float) -> int: ...
    def getStoneWallCurve(self) -> 'StoneWallCurve': ...
    def getSurgeCurve(self) -> 'SafeSplineSurgeCurve': ...
    def isUseCompressorChart(self) -> bool: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def plot(self) -> None: ...
    def polytropicEfficiency(self, double: float, double2: float) -> float: ...
    def prettyPrintChartValues(self) -> None: ...
    @typing.overload
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray6: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setGearRatio(self, double: float) -> None: ...
    def setHeadUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferenceConditions(self, double: float, double2: float, double3: float, double4: float) -> None: ...
    def setStoneWallCurve(self, stoneWallCurve: 'StoneWallCurve') -> None: ...
    def setSurgeCurve(self, safeSplineSurgeCurve: 'SafeSplineSurgeCurve') -> None: ...
    def setUseCompressorChart(self, boolean: bool) -> None: ...
    def setUseRealKappa(self, boolean: bool) -> None: ...
    def useRealKappa(self) -> bool: ...

class StoneWallCurve(BoundaryCurve):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]): ...
    def getStoneWallFlow(self, double: float) -> float: ...
    def isLimit(self, double: float, double2: float) -> bool: ...
    def isStoneWall(self, double: float, double2: float) -> bool: ...

class SurgeCurve(BoundaryCurve):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]): ...
    def getSurgeFlow(self, double: float) -> float: ...
    def isLimit(self, double: float, double2: float) -> bool: ...
    def isSurge(self, double: float, double2: float) -> bool: ...

class CompressorChartAlternativeMapLookupExtrapolate(CompressorChartAlternativeMapLookup):
    def __init__(self): ...
    def getClosestRefSpeeds(self, double: float) -> java.util.ArrayList[float]: ...
    def getPolytropicEfficiency(self, double: float, double2: float) -> float: ...
    def getPolytropicHead(self, double: float, double2: float) -> float: ...

class SafeSplineStoneWallCurve(StoneWallCurve):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]): ...
    @typing.overload
    def getFlow(self, double: float) -> float: ...
    @typing.overload
    def getFlow(self) -> typing.MutableSequence[float]: ...
    def getSortedFlow(self) -> typing.MutableSequence[float]: ...
    def getSortedHead(self) -> typing.MutableSequence[float]: ...
    def getStoneWallFlow(self, double: float) -> float: ...
    def getStoneWallHead(self, double: float) -> float: ...
    def isStoneWall(self, double: float, double2: float) -> bool: ...
    def setCurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class SafeSplineSurgeCurve(SurgeCurve):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]): ...
    @typing.overload
    def getFlow(self, double: float) -> float: ...
    @typing.overload
    def getFlow(self) -> typing.MutableSequence[float]: ...
    def getSortedFlow(self) -> typing.MutableSequence[float]: ...
    def getSortedHead(self) -> typing.MutableSequence[float]: ...
    def getSurgeFlow(self, double: float) -> float: ...
    def getSurgeHead(self, double: float) -> float: ...
    def isSurge(self, double: float, double2: float) -> bool: ...
    def setCurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class CompressorChartKhader2015(CompressorChartAlternativeMapLookupExtrapolate):
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, double: float): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def generateRealCurvesForFluid(self) -> None: ...
    def generateStoneWallCurve(self) -> None: ...
    def generateSurgeCurve(self) -> None: ...
    def getCorrectedCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray6: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> java.util.List['CompressorChartKhader2015.CorrectedCurve']: ...
    def getImpellerOuterDiameter(self) -> float: ...
    def getPolytropicEfficiency(self, double: float, double2: float) -> float: ...
    def getPolytropicHead(self, double: float, double2: float) -> float: ...
    def getRealCurves(self) -> java.util.List['CompressorChartKhader2015.RealCurve']: ...
    def getReferenceFluid(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def prettyPrintRealCurvesForFluid(self) -> None: ...
    @typing.overload
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setCurves(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray6: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setImpellerOuterDiameter(self, double: float) -> None: ...
    def setReferenceFluid(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    class CorrectedCurve:
        machineMachNumber: float = ...
        correctedFlowFactor: typing.MutableSequence[float] = ...
        correctedHeadFactor: typing.MutableSequence[float] = ...
        correctedFlowFactorEfficiency: typing.MutableSequence[float] = ...
        polytropicEfficiency: typing.MutableSequence[float] = ...
        def __init__(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray]): ...
    class RealCurve:
        speed: float = ...
        flow: typing.MutableSequence[float] = ...
        head: typing.MutableSequence[float] = ...
        flowPolyEff: typing.MutableSequence[float] = ...
        polytropicEfficiency: typing.MutableSequence[float] = ...
        def __init__(self, double: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray]): ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.compressor")``.

    AntiSurge: typing.Type[AntiSurge]
    BoundaryCurve: typing.Type[BoundaryCurve]
    BoundaryCurveInterface: typing.Type[BoundaryCurveInterface]
    Compressor: typing.Type[Compressor]
    CompressorChart: typing.Type[CompressorChart]
    CompressorChartAlternativeMapLookup: typing.Type[CompressorChartAlternativeMapLookup]
    CompressorChartAlternativeMapLookupExtrapolate: typing.Type[CompressorChartAlternativeMapLookupExtrapolate]
    CompressorChartGenerator: typing.Type[CompressorChartGenerator]
    CompressorChartInterface: typing.Type[CompressorChartInterface]
    CompressorChartKhader2015: typing.Type[CompressorChartKhader2015]
    CompressorChartReader: typing.Type[CompressorChartReader]
    CompressorCurve: typing.Type[CompressorCurve]
    CompressorInterface: typing.Type[CompressorInterface]
    CompressorPropertyProfile: typing.Type[CompressorPropertyProfile]
    SafeSplineStoneWallCurve: typing.Type[SafeSplineStoneWallCurve]
    SafeSplineSurgeCurve: typing.Type[SafeSplineSurgeCurve]
    StoneWallCurve: typing.Type[StoneWallCurve]
    SurgeCurve: typing.Type[SurgeCurve]
