
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.compressor
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.util.report
import typing



class ExpanderInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface, jneqsim.neqsim.process.equipment.TwoPortInterface):
    def equals(self, object: typing.Any) -> bool: ...
    def getEnergy(self) -> float: ...
    def hashCode(self) -> int: ...

class Expander(jneqsim.neqsim.process.equipment.compressor.Compressor, ExpanderInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class ExpanderOld(jneqsim.neqsim.process.equipment.TwoPortEquipment, ExpanderInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getEnergy(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setOutletPressure(self, double: float) -> None: ...

class TurboExpanderCompressor(Expander):
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def calcIGVOpenArea(self) -> float: ...
    def calcIGVOpening(self) -> float: ...
    def calcIGVOpeningFromFlow(self) -> float: ...
    def getBearingLossPower(self) -> float: ...
    def getCompressorDesignPolytropicEfficiency(self) -> float: ...
    def getCompressorDesignPolytropicHead(self) -> float: ...
    def getCompressorDesingPolytropicHead(self) -> float: ...
    def getCompressorFeedStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getCompressorOutletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getCompressorPolytropicEfficiency(self) -> float: ...
    def getCompressorPolytropicEfficieny(self) -> float: ...
    def getCompressorPolytropicHead(self) -> float: ...
    def getCompressorSpeed(self) -> float: ...
    def getDesignCompressorPolytropicEfficiency(self) -> float: ...
    def getDesignQn(self) -> float: ...
    def getDesignSpeed(self) -> float: ...
    def getDesignUC(self) -> float: ...
    def getEfficiencyFromQN(self, double: float) -> float: ...
    def getEfficiencyFromUC(self, double: float) -> float: ...
    def getExpanderDesignIsentropicEfficiency(self) -> float: ...
    def getExpanderFeedStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getExpanderIsentropicEfficiency(self) -> float: ...
    def getExpanderOutPressure(self) -> float: ...
    def getExpanderOutletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getExpanderSpeed(self) -> float: ...
    def getGearRatio(self) -> float: ...
    def getHeadFromQN(self, double: float) -> float: ...
    def getIGVopening(self) -> float: ...
    def getImpellerDiameter(self) -> float: ...
    def getMaximumIGVArea(self) -> float: ...
    def getOutletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getPowerCompressor(self) -> float: ...
    def getPowerExpander(self) -> float: ...
    def getQNratiocompressor(self) -> float: ...
    def getQNratioexpander(self) -> float: ...
    def getQn(self) -> float: ...
    def getQnCurveA(self) -> float: ...
    def getQnCurveH(self) -> float: ...
    def getQnCurveK(self) -> float: ...
    def getQnHeadCurveA(self) -> float: ...
    def getQnHeadCurveH(self) -> float: ...
    def getQnHeadCurveK(self) -> float: ...
    @staticmethod
    def getSerialversionuid() -> int: ...
    def getSpeed(self) -> float: ...
    def getUCratiocompressor(self) -> float: ...
    def getUCratioexpander(self) -> float: ...
    def getUcCurveA(self) -> float: ...
    def getUcCurveH(self) -> float: ...
    def getUcCurveK(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setCompressorDesignPolytropicEfficiency(self, double: float) -> None: ...
    def setCompressorDesignPolytropicHead(self, double: float) -> None: ...
    def setCompressorFeedStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setDesignQn(self, double: float) -> None: ...
    def setDesignSpeed(self, double: float) -> None: ...
    def setDesignUC(self, double: float) -> None: ...
    def setExpanderDesignIsentropicEfficiency(self, double: float) -> None: ...
    def setExpanderIsentropicEfficiency(self, double: float) -> None: ...
    def setExpanderOutPressure(self, double: float) -> None: ...
    def setIGVopening(self, double: float) -> None: ...
    def setImpellerDiameter(self, double: float) -> None: ...
    def setMaximumIGVArea(self, double: float) -> None: ...
    def setQNEfficiencycurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setQNHeadcurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setQNratiocompressor(self, double: float) -> None: ...
    def setQNratioexpander(self, double: float) -> None: ...
    def setQn(self, double: float) -> None: ...
    def setUCcurve(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setUCratiocompressor(self, double: float) -> None: ...
    def setUCratioexpander(self, double: float) -> None: ...
    @typing.overload
    def toJson(self) -> java.lang.String: ...
    @typing.overload
    def toJson(self, reportConfig: jneqsim.neqsim.process.util.report.ReportConfig) -> java.lang.String: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.expander")``.

    Expander: typing.Type[Expander]
    ExpanderInterface: typing.Type[ExpanderInterface]
    ExpanderOld: typing.Type[ExpanderOld]
    TurboExpanderCompressor: typing.Type[TurboExpanderCompressor]
