
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import typing



class Flare(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def getCO2Emission(self) -> float: ...
    @typing.overload
    def getCO2Emission(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getHeatDuty(self) -> float: ...
    @typing.overload
    def getHeatDuty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...

class FlareStack(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def chamberlainHeatFlux(self, double: float) -> float: ...
    def getEmissionsKgPerHr(self) -> java.util.Map[java.lang.String, float]: ...
    def getHeatReleaseMW(self) -> float: ...
    def getTipBackpressureBar(self) -> float: ...
    def heatFlux_W_m2(self, double: float) -> float: ...
    def pointSourceHeatFlux(self, double: float) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setAirAssist(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setAmbient(self, double: float, double2: float) -> None: ...
    def setBurningEfficiency(self, double: float) -> None: ...
    def setCOFraction(self, double: float) -> None: ...
    def setChamberlainAttenuation(self, double: float) -> None: ...
    def setChamberlainEmissivePower(self, double: float, double2: float) -> None: ...
    def setChamberlainFlameLength(self, double: float, double2: float, double3: float) -> None: ...
    def setChamberlainSegments(self, int: int) -> None: ...
    def setChamberlainTilt(self, double: float) -> None: ...
    def setExcessAirFrac(self, double: float) -> None: ...
    def setRadiantFraction(self, double: float) -> None: ...
    def setRadiationModel(self, radiationModel: 'FlareStack.RadiationModel') -> None: ...
    def setReliefInlet(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setSO2Conversion(self, double: float) -> None: ...
    def setSteamAssist(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setTipDiameter(self, double: float) -> None: ...
    def setTipElevation(self, double: float) -> None: ...
    def setTipLossK(self, double: float) -> None: ...
    def setUnburnedTHCFraction(self, double: float) -> None: ...
    def setWindSpeed10m(self, double: float) -> None: ...
    class RadiationModel(java.lang.Enum['FlareStack.RadiationModel']):
        POINT_SOURCE: typing.ClassVar['FlareStack.RadiationModel'] = ...
        CHAMBERLAIN: typing.ClassVar['FlareStack.RadiationModel'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: typing.Union[java.lang.String, str]) -> 'FlareStack.RadiationModel': ...
        @staticmethod
        def values() -> typing.MutableSequence['FlareStack.RadiationModel']: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.flare")``.

    Flare: typing.Type[Flare]
    FlareStack: typing.Type[FlareStack]
