
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.util.report
import jneqsim.neqsim.thermo.system
import typing



class MixerInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface):
    def addStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getOutletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def hashCode(self) -> int: ...
    def removeInputStream(self, int: int) -> None: ...
    def replaceStream(self, int: int, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...

class Mixer(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass, MixerInterface):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcMixStreamEnthalpy(self) -> float: ...
    def displayResult(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMixedSalinity(self) -> float: ...
    def getNumberOfInputStreams(self) -> int: ...
    def getOutTemperature(self) -> float: ...
    def getOutletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def guessTemperature(self) -> float: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def isSetOutTemperature(self) -> bool: ...
    @typing.overload
    def isSetOutTemperature(self, boolean: bool) -> None: ...
    def mixStream(self) -> None: ...
    def removeInputStream(self, int: int) -> None: ...
    def replaceStream(self, int: int, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setOutTemperature(self, double: float) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def toJson(self) -> java.lang.String: ...
    @typing.overload
    def toJson(self, reportConfig: jneqsim.neqsim.process.util.report.ReportConfig) -> java.lang.String: ...

class StaticMixer(Mixer):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def calcMixStreamEnthalpy(self) -> float: ...
    def guessTemperature(self) -> float: ...
    def mixStream(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def toJson(self) -> java.lang.String: ...
    @typing.overload
    def toJson(self, reportConfig: jneqsim.neqsim.process.util.report.ReportConfig) -> java.lang.String: ...

class StaticNeqMixer(StaticMixer):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def mixStream(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class StaticPhaseMixer(StaticMixer):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def mixStream(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.mixer")``.

    Mixer: typing.Type[Mixer]
    MixerInterface: typing.Type[MixerInterface]
    StaticMixer: typing.Type[StaticMixer]
    StaticNeqMixer: typing.Type[StaticNeqMixer]
    StaticPhaseMixer: typing.Type[StaticPhaseMixer]
