
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.fluidmechanics.flowsystem
import jneqsim.neqsim.process
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.mechanicaldesign.pipeline
import jneqsim.neqsim.process.util.report
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations
import typing



class Fittings(java.io.Serializable):
    def __init__(self): ...
    @typing.overload
    def add(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def add(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def getFittingsList(self) -> java.util.ArrayList['Fittings.Fitting']: ...
    class Fitting(java.io.Serializable):
        @typing.overload
        def __init__(self, fittings: 'Fittings', string: typing.Union[java.lang.String, str]): ...
        @typing.overload
        def __init__(self, fittings: 'Fittings', string: typing.Union[java.lang.String, str], double: float): ...
        def getFittingName(self) -> java.lang.String: ...
        def getLtoD(self) -> float: ...
        def setFittingName(self, string: typing.Union[java.lang.String, str]) -> None: ...
        def setLtoD(self, double: float) -> None: ...

class PipeLineInterface(jneqsim.neqsim.process.SimulationInterface, jneqsim.neqsim.process.equipment.TwoPortInterface):
    def getPipe(self) -> jneqsim.neqsim.fluidmechanics.flowsystem.FlowSystemInterface: ...
    def setHeightProfile(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setInitialFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLegPositions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setNumberOfLegs(self, int: int) -> None: ...
    def setNumberOfNodesInLeg(self, int: int) -> None: ...
    def setOuterTemperatures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setOutputFileName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPipeDiameters(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setPipeWallRoughness(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class Pipeline(jneqsim.neqsim.process.equipment.TwoPortEquipment, PipeLineInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.pipeline.PipelineMechanicalDesign: ...
    @typing.overload
    def getOutletPressure(self) -> float: ...
    @typing.overload
    def getOutletPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getPipe(self) -> jneqsim.neqsim.fluidmechanics.flowsystem.FlowSystemInterface: ...
    def getSuperficialVelocity(self, int: int, int2: int) -> float: ...
    def getTimes(self) -> typing.MutableSequence[float]: ...
    def initMechanicalDesign(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setEquilibriumHeatTransfer(self, boolean: bool) -> None: ...
    def setEquilibriumMassTransfer(self, boolean: bool) -> None: ...
    def setHeightProfile(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setInitialFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLegPositions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setNumberOfLegs(self, int: int) -> None: ...
    def setNumberOfNodesInLeg(self, int: int) -> None: ...
    def setOuterTemperatures(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setOutputFileName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPipeDiameters(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setPipeOuterHeatTransferCoefficients(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setPipeWallHeatTransferCoefficients(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setPipeWallRoughness(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setTimeSeries(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], systemInterfaceArray: typing.Union[typing.List[jneqsim.neqsim.thermo.system.SystemInterface], jpype.JArray], int: int) -> None: ...

class AdiabaticPipe(Pipeline):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def calcFlow(self) -> float: ...
    def calcPressureOut(self) -> float: ...
    def calcWallFrictionFactor(self, double: float) -> float: ...
    def displayResult(self) -> None: ...
    def getDiameter(self) -> float: ...
    def getInletElevation(self) -> float: ...
    def getLength(self) -> float: ...
    def getOutletElevation(self) -> float: ...
    def getPipe(self) -> jneqsim.neqsim.fluidmechanics.flowsystem.FlowSystemInterface: ...
    def getPipeWallRoughness(self) -> float: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDiameter(self, double: float) -> None: ...
    def setInitialFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInletElevation(self, double: float) -> None: ...
    def setLength(self, double: float) -> None: ...
    def setOutPressure(self, double: float) -> None: ...
    def setOutTemperature(self, double: float) -> None: ...
    def setOutletElevation(self, double: float) -> None: ...
    def setPipeSpecification(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPipeWallRoughness(self, double: float) -> None: ...
    @typing.overload
    def setPipeWallRoughness(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class AdiabaticTwoPhasePipe(Pipeline):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def calcFlow(self, double: float) -> float: ...
    def calcPressureOut(self) -> float: ...
    def calcWallFrictionFactor(self, double: float) -> float: ...
    def displayResult(self) -> None: ...
    def getDiameter(self) -> float: ...
    def getInletElevation(self) -> float: ...
    def getLength(self) -> float: ...
    def getOutletElevation(self) -> float: ...
    def getPipe(self) -> jneqsim.neqsim.fluidmechanics.flowsystem.FlowSystemInterface: ...
    def getPipeWallRoughness(self) -> float: ...
    def getPressureOutLimit(self) -> float: ...
    @typing.overload
    def getSuperficialVelocity(self) -> float: ...
    @typing.overload
    def getSuperficialVelocity(self, int: int, int2: int) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDiameter(self, double: float) -> None: ...
    def setFlowLimit(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInitialFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInletElevation(self, double: float) -> None: ...
    def setLength(self, double: float) -> None: ...
    def setOutPressure(self, double: float) -> None: ...
    def setOutTemperature(self, double: float) -> None: ...
    def setOutletElevation(self, double: float) -> None: ...
    def setPipeSpecification(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPipeWallRoughness(self, double: float) -> None: ...
    @typing.overload
    def setPipeWallRoughness(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setPressureOutLimit(self, double: float) -> None: ...

class OnePhasePipeLine(Pipeline):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def createSystem(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class PipeBeggsAndBrills(Pipeline):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def calcFlowRegime(self) -> 'PipeBeggsAndBrills.FlowRegime': ...
    def calcFrictionPressureLoss(self) -> float: ...
    def calcHeatBalance(self, double: float, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, thermodynamicOperations: jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations) -> float: ...
    def calcHydrostaticPressureDifference(self) -> float: ...
    def calcPressureDrop(self) -> float: ...
    def calcTemperatureDifference(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> float: ...
    def calculateMissingValue(self) -> None: ...
    def convertSystemUnitToImperial(self) -> None: ...
    def convertSystemUnitToMetric(self) -> None: ...
    def displayResult(self) -> None: ...
    def estimateHeatTransferCoefficent(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> float: ...
    def getAngle(self) -> float: ...
    def getDiameter(self) -> float: ...
    def getElevation(self) -> float: ...
    def getElevationProfile(self) -> java.util.List[float]: ...
    def getFlowRegime(self) -> 'PipeBeggsAndBrills.FlowRegime': ...
    def getFlowRegimeProfile(self) -> java.util.List['PipeBeggsAndBrills.FlowRegime']: ...
    def getGasSuperficialVelocityProfile(self) -> java.util.List[float]: ...
    def getHeatTransferCoefficient(self) -> float: ...
    def getIncrementsProfile(self) -> java.util.List[int]: ...
    def getInletSuperficialVelocity(self) -> float: ...
    def getLastSegmentPressureDrop(self) -> float: ...
    def getLength(self) -> float: ...
    def getLengthProfile(self) -> java.util.List[float]: ...
    def getLiquidDensityProfile(self) -> java.util.List[float]: ...
    def getLiquidHoldupProfile(self) -> java.util.List[float]: ...
    def getLiquidSuperficialVelocityProfile(self) -> java.util.List[float]: ...
    def getMixtureDensityProfile(self) -> java.util.List[float]: ...
    def getMixtureReynoldsNumber(self) -> java.util.List[float]: ...
    def getMixtureSuperficialVelocityProfile(self) -> java.util.List[float]: ...
    def getMixtureViscosityProfile(self) -> java.util.List[float]: ...
    def getNumberOfIncrements(self) -> int: ...
    def getOutletSuperficialVelocity(self) -> float: ...
    def getPressureDrop(self) -> float: ...
    def getPressureDropProfile(self) -> java.util.List[float]: ...
    def getPressureProfile(self) -> java.util.List[float]: ...
    def getSegmentElevation(self, int: int) -> float: ...
    def getSegmentFlowRegime(self, int: int) -> 'PipeBeggsAndBrills.FlowRegime': ...
    def getSegmentGasSuperficialVelocity(self, int: int) -> float: ...
    def getSegmentLength(self, int: int) -> float: ...
    def getSegmentLiquidDensity(self, int: int) -> float: ...
    def getSegmentLiquidHoldup(self, int: int) -> float: ...
    def getSegmentLiquidSuperficialVelocity(self, int: int) -> float: ...
    def getSegmentMixtureDensity(self, int: int) -> float: ...
    def getSegmentMixtureReynoldsNumber(self, int: int) -> float: ...
    def getSegmentMixtureSuperficialVelocity(self, int: int) -> float: ...
    def getSegmentMixtureViscosity(self, int: int) -> float: ...
    def getSegmentPressure(self, int: int) -> float: ...
    def getSegmentPressureDrop(self, int: int) -> float: ...
    def getSegmentTemperature(self, int: int) -> float: ...
    def getTemperatureProfile(self) -> java.util.List[float]: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getThickness(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setAngle(self, double: float) -> None: ...
    def setConstantSurfaceTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setDiameter(self, double: float) -> None: ...
    def setElevation(self, double: float) -> None: ...
    def setHeatTransferCoefficient(self, double: float) -> None: ...
    def setLength(self, double: float) -> None: ...
    def setNumberOfIncrements(self, int: int) -> None: ...
    def setPipeSpecification(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPipeWallRoughness(self, double: float) -> None: ...
    @typing.overload
    def setPipeWallRoughness(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setRunIsothermal(self, boolean: bool) -> None: ...
    def setThickness(self, double: float) -> None: ...
    @typing.overload
    def toJson(self) -> java.lang.String: ...
    @typing.overload
    def toJson(self, reportConfig: jneqsim.neqsim.process.util.report.ReportConfig) -> java.lang.String: ...
    class FlowRegime(java.lang.Enum['PipeBeggsAndBrills.FlowRegime']):
        SEGREGATED: typing.ClassVar['PipeBeggsAndBrills.FlowRegime'] = ...
        INTERMITTENT: typing.ClassVar['PipeBeggsAndBrills.FlowRegime'] = ...
        DISTRIBUTED: typing.ClassVar['PipeBeggsAndBrills.FlowRegime'] = ...
        TRANSITION: typing.ClassVar['PipeBeggsAndBrills.FlowRegime'] = ...
        SINGLE_PHASE: typing.ClassVar['PipeBeggsAndBrills.FlowRegime'] = ...
        UNKNOWN: typing.ClassVar['PipeBeggsAndBrills.FlowRegime'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: typing.Union[java.lang.String, str]) -> 'PipeBeggsAndBrills.FlowRegime': ...
        @staticmethod
        def values() -> typing.MutableSequence['PipeBeggsAndBrills.FlowRegime']: ...

class SimpleTPoutPipeline(Pipeline):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getPipe(self) -> jneqsim.neqsim.fluidmechanics.flowsystem.FlowSystemInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInitialFlowPattern(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setOutPressure(self, double: float) -> None: ...
    def setOutTemperature(self, double: float) -> None: ...

class TwoPhasePipeLine(Pipeline):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def createSystem(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class IncompressiblePipeFlow(AdiabaticPipe):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def addFitting(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def addFittingFromDatabase(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def calcPressureOut(self) -> float: ...
    def getTotalEqLenth(self) -> float: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setTotalEqLenth(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.pipeline")``.

    AdiabaticPipe: typing.Type[AdiabaticPipe]
    AdiabaticTwoPhasePipe: typing.Type[AdiabaticTwoPhasePipe]
    Fittings: typing.Type[Fittings]
    IncompressiblePipeFlow: typing.Type[IncompressiblePipeFlow]
    OnePhasePipeLine: typing.Type[OnePhasePipeLine]
    PipeBeggsAndBrills: typing.Type[PipeBeggsAndBrills]
    PipeLineInterface: typing.Type[PipeLineInterface]
    Pipeline: typing.Type[Pipeline]
    SimpleTPoutPipeline: typing.Type[SimpleTPoutPipeline]
    TwoPhasePipeLine: typing.Type[TwoPhasePipeLine]
