
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.util
import typing



class ReservoirCVDsim(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class ReservoirDiffLibsim(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...

class ReservoirTPsim(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getProdPhaseName(self) -> java.lang.String: ...
    def getReserervourFluid(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setProdPhaseName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...

class SimpleReservoir(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def GORprodution(self) -> float: ...
    def addGasInjector(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def addGasProducer(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def addOilProducer(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def addWaterInjector(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def addWaterProducer(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def displayResult(self) -> None: ...
    def getGasInPlace(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getGasInjector(self, int: int) -> 'Well': ...
    def getGasProducer(self, int: int) -> 'Well': ...
    def getGasProductionTotal(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getGasProdution(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getLowPressureLimit(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getOGIP(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getOOIP(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getOilInPlace(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getOilProducer(self, int: int) -> 'Well': ...
    @typing.overload
    def getOilProducer(self, string: typing.Union[java.lang.String, str]) -> 'Well': ...
    def getOilProductionTotal(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getOilProdution(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getProductionTotal(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getReservoirFluid(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getTime(self) -> float: ...
    def getWaterInjector(self, int: int) -> 'Well': ...
    def getWaterProducer(self, int: int) -> 'Well': ...
    def getWaterProdution(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setLowPressureLimit(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReservoirFluid(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float, double3: float) -> None: ...

class Well(jneqsim.neqsim.util.NamedBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def getGOR(self) -> float: ...
    def getStdGasProduction(self) -> float: ...
    def getStdOilProduction(self) -> float: ...
    def getStdWaterProduction(self) -> float: ...
    def getStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def setStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...

class WellFlow(jneqsim.neqsim.process.equipment.TwoPortEquipment):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def getWellProductionIndex(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setDarcyLawParameters(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float) -> None: ...
    def setFetkovichParameters(self, double: float, double2: float, double3: float) -> None: ...
    def setVogelParameters(self, double: float, double2: float, double3: float) -> None: ...
    def setWellProductionIndex(self, double: float) -> None: ...
    class InflowPerformanceModel(java.lang.Enum['WellFlow.InflowPerformanceModel']):
        PRODUCTION_INDEX: typing.ClassVar['WellFlow.InflowPerformanceModel'] = ...
        VOGEL: typing.ClassVar['WellFlow.InflowPerformanceModel'] = ...
        FETKOVICH: typing.ClassVar['WellFlow.InflowPerformanceModel'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: typing.Union[java.lang.String, str]) -> 'WellFlow.InflowPerformanceModel': ...
        @staticmethod
        def values() -> typing.MutableSequence['WellFlow.InflowPerformanceModel']: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.reservoir")``.

    ReservoirCVDsim: typing.Type[ReservoirCVDsim]
    ReservoirDiffLibsim: typing.Type[ReservoirDiffLibsim]
    ReservoirTPsim: typing.Type[ReservoirTPsim]
    SimpleReservoir: typing.Type[SimpleReservoir]
    Well: typing.Type[Well]
    WellFlow: typing.Type[WellFlow]
