
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import typing



class ComponentSplitter(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getSplitStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setSplitFactors(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...

class SplitterInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface):
    def equals(self, object: typing.Any) -> bool: ...
    def getSplitStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def hashCode(self) -> int: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setSplitNumber(self, int: int) -> None: ...

class Splitter(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass, SplitterInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface, int: int): ...
    def calcSplitFactors(self) -> None: ...
    def displayResult(self) -> None: ...
    def getInletStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getSplitFactor(self, int: int) -> float: ...
    def getSplitFactors(self) -> typing.MutableSequence[float]: ...
    def getSplitStream(self, int: int) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def needRecalculation(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setFlowRates(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], string: typing.Union[java.lang.String, str]) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setSplitFactors(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setSplitNumber(self, int: int) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.splitter")``.

    ComponentSplitter: typing.Type[ComponentSplitter]
    Splitter: typing.Type[Splitter]
    SplitterInterface: typing.Type[SplitterInterface]
