
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.util.report
import jneqsim.neqsim.thermo.system
import typing



class Tank(jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def addStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def displayResult(self) -> None: ...
    def getEfficiency(self) -> float: ...
    def getGas(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getGasCarryunderFraction(self) -> float: ...
    def getGasOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquid(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getLiquidCarryoverFraction(self) -> float: ...
    def getLiquidLevel(self) -> float: ...
    def getLiquidOutStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getVolume(self) -> float: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    def setEfficiency(self, double: float) -> None: ...
    def setGasCarryunderFraction(self, double: float) -> None: ...
    def setInletStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setLiquidCarryoverFraction(self, double: float) -> None: ...
    def setOutComposition(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setTempPres(self, double: float, double2: float) -> None: ...
    def setVolume(self, double: float) -> None: ...
    @typing.overload
    def toJson(self) -> java.lang.String: ...
    @typing.overload
    def toJson(self, reportConfig: jneqsim.neqsim.process.util.report.ReportConfig) -> java.lang.String: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.equipment.tank")``.

    Tank: typing.Type[Tank]
