
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jneqsim.neqsim.process.equipment.compressor
import jneqsim.neqsim.process.equipment.pipeline
import jneqsim.neqsim.process.equipment.separator
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.measurementdevice.online
import jneqsim.neqsim.process.measurementdevice.simpleflowregime
import jneqsim.neqsim.util
import typing



class MeasurementDeviceInterface(jneqsim.neqsim.util.NamedInterface, java.io.Serializable):
    def displayResult(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getMaximumValue(self) -> float: ...
    def getMeasuredPercentValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    def getMinimumValue(self) -> float: ...
    def getOnlineSignal(self) -> jneqsim.neqsim.process.measurementdevice.online.OnlineSignal: ...
    def getOnlineValue(self) -> float: ...
    def getUnit(self) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def isLogging(self) -> bool: ...
    def isOnlineSignal(self) -> bool: ...
    def setLogging(self, boolean: bool) -> None: ...
    def setMaximumValue(self, double: float) -> None: ...
    def setMinimumValue(self, double: float) -> None: ...
    def setUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...

class MeasurementDeviceBaseClass(jneqsim.neqsim.util.NamedBaseClass, MeasurementDeviceInterface):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    def displayResult(self) -> None: ...
    def doConditionAnalysis(self) -> bool: ...
    def getConditionAnalysisMaxDeviation(self) -> float: ...
    def getConditionAnalysisMessage(self) -> java.lang.String: ...
    def getDelaySteps(self) -> int: ...
    def getMaximumValue(self) -> float: ...
    def getMeasuredPercentValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMinimumValue(self) -> float: ...
    def getNoiseStdDev(self) -> float: ...
    def getOnlineMeasurementValue(self) -> float: ...
    def getOnlineSignal(self) -> jneqsim.neqsim.process.measurementdevice.online.OnlineSignal: ...
    def getUnit(self) -> java.lang.String: ...
    def isLogging(self) -> bool: ...
    def isOnlineSignal(self) -> bool: ...
    def runConditionAnalysis(self) -> None: ...
    def setConditionAnalysis(self, boolean: bool) -> None: ...
    def setConditionAnalysisMaxDeviation(self, double: float) -> None: ...
    def setDelaySteps(self, int: int) -> None: ...
    def setIsOnlineSignal(self, boolean: bool, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setLogging(self, boolean: bool) -> None: ...
    def setMaximumValue(self, double: float) -> None: ...
    def setMinimumValue(self, double: float) -> None: ...
    def setNoiseStdDev(self, double: float) -> None: ...
    def setOnlineMeasurementValue(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setOnlineSignal(self, onlineSignal: jneqsim.neqsim.process.measurementdevice.online.OnlineSignal) -> None: ...
    def setQualityCheckMessage(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setRandomSeed(self, long: int) -> None: ...
    def setUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...

class CompressorMonitor(MeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], compressor: jneqsim.neqsim.process.equipment.compressor.Compressor): ...
    @typing.overload
    def __init__(self, compressor: jneqsim.neqsim.process.equipment.compressor.Compressor): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...

class FlowInducedVibrationAnalyser(MeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], pipeBeggsAndBrills: jneqsim.neqsim.process.equipment.pipeline.PipeBeggsAndBrills): ...
    @typing.overload
    def __init__(self, pipeBeggsAndBrills: jneqsim.neqsim.process.equipment.pipeline.PipeBeggsAndBrills): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMethod(self) -> java.lang.String: ...
    def setFRMSConstant(self, double: float) -> None: ...
    def setMethod(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSegment(self, int: int) -> None: ...
    def setSupportArrangement(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSupportDistance(self, double: float) -> None: ...

class LevelTransmitter(MeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    @typing.overload
    def __init__(self, separator: jneqsim.neqsim.process.equipment.separator.Separator): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...

class StreamMeasurementDeviceBaseClass(MeasurementDeviceBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getStream(self) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def setStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...

class CombustionEmissionsCalculator(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @staticmethod
    def calculateCO2Emissions(map: typing.Union[java.util.Map[typing.Union[java.lang.String, str], float], typing.Mapping[typing.Union[java.lang.String, str], float]], map2: typing.Union[java.util.Map[typing.Union[java.lang.String, str], float], typing.Mapping[typing.Union[java.lang.String, str], float]]) -> float: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def setComponents(self) -> None: ...

class CricondenbarAnalyser(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMeasuredValue2(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...

class HydrateEquilibriumTemperatureAnalyser(StreamMeasurementDeviceBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getReferencePressure(self) -> float: ...
    def setReferencePressure(self, double: float) -> None: ...

class HydrocarbonDewPointAnalyser(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMethod(self) -> java.lang.String: ...
    def getReferencePressure(self) -> float: ...
    def setMethod(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferencePressure(self, double: float) -> None: ...

class MolarMassAnalyser(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...

class MultiPhaseMeter(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def getPressure(self) -> float: ...
    def getTemperature(self) -> float: ...
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...

class NMVOCAnalyser(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getnmVOCFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...

class PressureTransmitter(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...

class TemperatureTransmitter(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...

class VolumeFlowTransmitter(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    def getMeasuredPhaseNumber(self) -> int: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def setMeasuredPhaseNumber(self, int: int) -> None: ...

class WaterContentAnalyser(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...

class WaterDewPointAnalyser(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def displayResult(self) -> None: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMethod(self) -> java.lang.String: ...
    def getReferencePressure(self) -> float: ...
    def setMethod(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setReferencePressure(self, double: float) -> None: ...

class WellAllocator(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def setExportGasStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def setExportOilStream(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...

class pHProbe(StreamMeasurementDeviceBaseClass):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    @typing.overload
    def __init__(self, streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface): ...
    def getAlkalinity(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self) -> float: ...
    @typing.overload
    def getMeasuredValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def run(self) -> None: ...
    def setAlkalinity(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.measurementdevice")``.

    CombustionEmissionsCalculator: typing.Type[CombustionEmissionsCalculator]
    CompressorMonitor: typing.Type[CompressorMonitor]
    CricondenbarAnalyser: typing.Type[CricondenbarAnalyser]
    FlowInducedVibrationAnalyser: typing.Type[FlowInducedVibrationAnalyser]
    HydrateEquilibriumTemperatureAnalyser: typing.Type[HydrateEquilibriumTemperatureAnalyser]
    HydrocarbonDewPointAnalyser: typing.Type[HydrocarbonDewPointAnalyser]
    LevelTransmitter: typing.Type[LevelTransmitter]
    MeasurementDeviceBaseClass: typing.Type[MeasurementDeviceBaseClass]
    MeasurementDeviceInterface: typing.Type[MeasurementDeviceInterface]
    MolarMassAnalyser: typing.Type[MolarMassAnalyser]
    MultiPhaseMeter: typing.Type[MultiPhaseMeter]
    NMVOCAnalyser: typing.Type[NMVOCAnalyser]
    PressureTransmitter: typing.Type[PressureTransmitter]
    StreamMeasurementDeviceBaseClass: typing.Type[StreamMeasurementDeviceBaseClass]
    TemperatureTransmitter: typing.Type[TemperatureTransmitter]
    VolumeFlowTransmitter: typing.Type[VolumeFlowTransmitter]
    WaterContentAnalyser: typing.Type[WaterContentAnalyser]
    WaterDewPointAnalyser: typing.Type[WaterDewPointAnalyser]
    WellAllocator: typing.Type[WellAllocator]
    pHProbe: typing.Type[pHProbe]
    online: jneqsim.neqsim.process.measurementdevice.online.__module_protocol__
    simpleflowregime: jneqsim.neqsim.process.measurementdevice.simpleflowregime.__module_protocol__
