
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import jneqsim.neqsim.process.mechanicaldesign
import typing



class DesignStandard(java.io.Serializable):
    equipment: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign = ...
    standardName: java.lang.String = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getEquipment(self) -> jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign: ...
    def getStandardName(self) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def setDesignStandardName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setEquipment(self, mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign) -> None: ...
    def setStandardName(self, string: typing.Union[java.lang.String, str]) -> None: ...

class AbsorptionColumnDesignStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getMolecularSieveWaterCapacity(self) -> float: ...
    def setMolecularSieveWaterCapacity(self, double: float) -> None: ...

class AdsorptionDehydrationDesignStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getMolecularSieveWaterCapacity(self) -> float: ...
    def setMolecularSieveWaterCapacity(self, double: float) -> None: ...

class CompressorDesignStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getCompressorFactor(self) -> float: ...
    def setCompressorFactor(self, double: float) -> None: ...

class GasScrubberDesignStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getGasLoadFactor(self) -> float: ...
    def getVolumetricDesignFactor(self) -> float: ...

class JointEfficiencyPipelineStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getJEFactor(self) -> float: ...
    def readJointEfficiencyStandard(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setJEFactor(self, double: float) -> None: ...

class JointEfficiencyPlateStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getJEFactor(self) -> float: ...
    def readJointEfficiencyStandard(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setJEFactor(self, double: float) -> None: ...

class MaterialPipeDesignStandard(DesignStandard):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getDesignFactor(self) -> float: ...
    def getEfactor(self) -> float: ...
    def getMinimumYeildStrength(self) -> float: ...
    def getTemperatureDeratingFactor(self) -> float: ...
    def readMaterialDesignStandard(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setDesignFactor(self, double: float) -> None: ...
    def setEfactor(self, double: float) -> None: ...
    def setMinimumYeildStrength(self, double: float) -> None: ...
    def setTemperatureDeratingFactor(self, double: float) -> None: ...

class MaterialPlateDesignStandard(DesignStandard):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getDivisionClass(self) -> float: ...
    def readMaterialDesignStandard(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], int: int) -> None: ...
    def setDivisionClass(self, double: float) -> None: ...

class PipelineDesignStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def calcPipelineWallThickness(self) -> float: ...

class PipingDesignStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...

class PressureVesselDesignStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def calcWallThickness(self) -> float: ...

class SeparatorDesignStandard(DesignStandard):
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getFg(self) -> float: ...
    def getGasLoadFactor(self) -> float: ...
    def getLiquidRetentionTime(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign) -> float: ...
    def getVolumetricDesignFactor(self) -> float: ...
    def setFg(self, double: float) -> None: ...
    def setVolumetricDesignFactor(self, double: float) -> None: ...

class ValveDesignStandard(DesignStandard):
    valveCvMax: float = ...
    def __init__(self, string: typing.Union[java.lang.String, str], mechanicalDesign: jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign): ...
    def getValveCvMax(self) -> float: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.mechanicaldesign.designstandards")``.

    AbsorptionColumnDesignStandard: typing.Type[AbsorptionColumnDesignStandard]
    AdsorptionDehydrationDesignStandard: typing.Type[AdsorptionDehydrationDesignStandard]
    CompressorDesignStandard: typing.Type[CompressorDesignStandard]
    DesignStandard: typing.Type[DesignStandard]
    GasScrubberDesignStandard: typing.Type[GasScrubberDesignStandard]
    JointEfficiencyPipelineStandard: typing.Type[JointEfficiencyPipelineStandard]
    JointEfficiencyPlateStandard: typing.Type[JointEfficiencyPlateStandard]
    MaterialPipeDesignStandard: typing.Type[MaterialPipeDesignStandard]
    MaterialPlateDesignStandard: typing.Type[MaterialPlateDesignStandard]
    PipelineDesignStandard: typing.Type[PipelineDesignStandard]
    PipingDesignStandard: typing.Type[PipingDesignStandard]
    PressureVesselDesignStandard: typing.Type[PressureVesselDesignStandard]
    SeparatorDesignStandard: typing.Type[SeparatorDesignStandard]
    ValveDesignStandard: typing.Type[ValveDesignStandard]
