
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jpype.protocol
import jneqsim.neqsim.process
import jneqsim.neqsim.process.conditionmonitor
import jneqsim.neqsim.process.controllerdevice
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.measurementdevice
import jneqsim.neqsim.process.mechanicaldesign
import jneqsim.neqsim.process.processmodel.processmodules
import jneqsim.neqsim.process.util.report
import jneqsim.neqsim.thermo.system
import typing



class ModuleInterface(jneqsim.neqsim.process.equipment.ProcessEquipmentInterface):
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getOperations(self) -> 'ProcessSystem': ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getPreferedThermodynamicModel(self) -> java.lang.String: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def hashCode(self) -> int: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    def isCalcDesign(self) -> bool: ...
    def setIsCalcDesign(self, boolean: bool) -> None: ...
    def setPreferedThermodynamicModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setProperty(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...

class ProcessLoader:
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def loadProcessFromYaml(file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: typing.Union[java.lang.String, str], processSystem: 'ProcessSystem') -> None: ...
    @typing.overload
    @staticmethod
    def loadProcessFromYaml(file: typing.Union[java.io.File, jpype.protocol.SupportsPath], processSystem: 'ProcessSystem') -> None: ...
    @typing.overload
    @staticmethod
    def loadProcessFromYaml(string: typing.Union[java.lang.String, str], processSystem: 'ProcessSystem') -> None: ...

class ProcessModel(java.lang.Runnable):
    def __init__(self): ...
    def add(self, string: typing.Union[java.lang.String, str], processSystem: 'ProcessSystem') -> bool: ...
    def get(self, string: typing.Union[java.lang.String, str]) -> 'ProcessSystem': ...
    def getAllProcesses(self) -> java.util.Collection['ProcessSystem']: ...
    def getReport_json(self) -> java.lang.String: ...
    def getThreads(self) -> java.util.Map[java.lang.String, java.lang.Thread]: ...
    def isFinished(self) -> bool: ...
    def isRunStep(self) -> bool: ...
    def remove(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def run(self) -> None: ...
    def runAsThread(self) -> java.lang.Thread: ...
    def runStep(self) -> None: ...
    def setRunStep(self, boolean: bool) -> None: ...

class ProcessModule(jneqsim.neqsim.process.SimulationBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def add(self, processModule: 'ProcessModule') -> None: ...
    @typing.overload
    def add(self, processSystem: 'ProcessSystem') -> None: ...
    def checkModulesRecycles(self) -> None: ...
    def copy(self) -> 'ProcessModule': ...
    def getAddedModules(self) -> java.util.List['ProcessModule']: ...
    def getAddedUnitOperations(self) -> java.util.List['ProcessSystem']: ...
    def getMeasurementDevice(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def getModulesIndex(self) -> java.util.List[int]: ...
    def getOperationsIndex(self) -> java.util.List[int]: ...
    def getReport(self) -> java.util.ArrayList[typing.MutableSequence[java.lang.String]]: ...
    def getReport_json(self) -> java.lang.String: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def recyclesSolved(self) -> bool: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runAsThread(self) -> java.lang.Thread: ...
    @typing.overload
    def run_step(self) -> None: ...
    @typing.overload
    def run_step(self, uUID: java.util.UUID) -> None: ...
    def solved(self) -> bool: ...

class ProcessSystem(jneqsim.neqsim.process.SimulationBaseClass):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def add(self, int: int, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    @typing.overload
    def add(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    @typing.overload
    def add(self, processEquipmentInterfaceArray: typing.Union[typing.List[jneqsim.neqsim.process.equipment.ProcessEquipmentInterface], jpype.JArray]) -> None: ...
    @typing.overload
    def add(self, measurementDeviceInterface: jneqsim.neqsim.process.measurementdevice.MeasurementDeviceInterface) -> None: ...
    _addUnit_0__T = typing.TypeVar('_addUnit_0__T', bound=jneqsim.neqsim.process.equipment.ProcessEquipmentInterface)  # <T>
    _addUnit_1__T = typing.TypeVar('_addUnit_1__T', bound=jneqsim.neqsim.process.equipment.ProcessEquipmentInterface)  # <T>
    _addUnit_2__T = typing.TypeVar('_addUnit_2__T', bound=jneqsim.neqsim.process.equipment.ProcessEquipmentInterface)  # <T>
    _addUnit_3__T = typing.TypeVar('_addUnit_3__T', bound=jneqsim.neqsim.process.equipment.ProcessEquipmentInterface)  # <T>
    _addUnit_5__T = typing.TypeVar('_addUnit_5__T', bound=jneqsim.neqsim.process.equipment.ProcessEquipmentInterface)  # <T>
    @typing.overload
    def addUnit(self, string: typing.Union[java.lang.String, str]) -> _addUnit_0__T: ...
    @typing.overload
    def addUnit(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> _addUnit_1__T: ...
    @typing.overload
    def addUnit(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> _addUnit_2__T: ...
    @typing.overload
    def addUnit(self, string: typing.Union[java.lang.String, str], equipmentEnum: jneqsim.neqsim.process.equipment.EquipmentEnum) -> _addUnit_3__T: ...
    @typing.overload
    def addUnit(self, string: typing.Union[java.lang.String, str], processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> jneqsim.neqsim.process.equipment.ProcessEquipmentInterface: ...
    @typing.overload
    def addUnit(self, equipmentEnum: jneqsim.neqsim.process.equipment.EquipmentEnum) -> _addUnit_5__T: ...
    @typing.overload
    def addUnit(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> jneqsim.neqsim.process.equipment.ProcessEquipmentInterface: ...
    def clear(self) -> None: ...
    def clearAll(self) -> None: ...
    def copy(self) -> 'ProcessSystem': ...
    def displayResult(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def exportToGraphviz(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getAllUnitNames(self) -> java.util.ArrayList[java.lang.String]: ...
    def getConditionMonitor(self) -> jneqsim.neqsim.process.conditionmonitor.ConditionMonitor: ...
    def getCoolerDuty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getHeaterDuty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMeasurementDevice(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.measurementdevice.MeasurementDeviceInterface: ...
    def getName(self) -> java.lang.String: ...
    def getPower(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getReport_json(self) -> java.lang.String: ...
    def getSurroundingTemperature(self) -> float: ...
    @typing.overload
    def getTime(self) -> float: ...
    @typing.overload
    def getTime(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTimeStep(self) -> float: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.ProcessEquipmentInterface: ...
    def getUnitNumber(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getUnitOperations(self) -> java.util.List[jneqsim.neqsim.process.equipment.ProcessEquipmentInterface]: ...
    def hasUnitName(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def hashCode(self) -> int: ...
    def isRunStep(self) -> bool: ...
    def loadProcessFromYaml(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @staticmethod
    def open(string: typing.Union[java.lang.String, str]) -> 'ProcessSystem': ...
    def printLogFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def removeUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def replaceObject(self, string: typing.Union[java.lang.String, str], processEquipmentBaseClass: jneqsim.neqsim.process.equipment.ProcessEquipmentBaseClass) -> None: ...
    def replaceUnit(self, string: typing.Union[java.lang.String, str], processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> bool: ...
    def reportMeasuredValues(self) -> None: ...
    def reportResults(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def runAsThread(self) -> java.lang.Thread: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def run_step(self) -> None: ...
    @typing.overload
    def run_step(self, uUID: java.util.UUID) -> None: ...
    def save(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setFluid(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    @typing.overload
    def setFluid(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, systemInterface2: jneqsim.neqsim.thermo.system.SystemInterface, boolean: bool) -> None: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setRunStep(self, boolean: bool) -> None: ...
    def setSurroundingTemperature(self, double: float) -> None: ...
    def setTimeStep(self, double: float) -> None: ...
    def size(self) -> int: ...
    def solved(self) -> bool: ...
    def view(self) -> None: ...

class ProcessModuleBaseClass(jneqsim.neqsim.process.SimulationBaseClass, ModuleInterface):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def calcDesign(self) -> None: ...
    def displayResult(self) -> None: ...
    def getConditionAnalysisMessage(self) -> java.lang.String: ...
    def getController(self) -> jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface: ...
    def getEntropyProduction(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getExergyChange(self, string: typing.Union[java.lang.String, str], double: float) -> float: ...
    def getMassBalance(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMechanicalDesign(self) -> jneqsim.neqsim.process.mechanicaldesign.MechanicalDesign: ...
    def getOperations(self) -> ProcessSystem: ...
    def getPreferedThermodynamicModel(self) -> java.lang.String: ...
    @typing.overload
    def getPressure(self) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getReport_json(self) -> java.lang.String: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSpecification(self) -> java.lang.String: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def isCalcDesign(self) -> bool: ...
    def reportResults(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def runConditionAnalysis(self, processEquipmentInterface: jneqsim.neqsim.process.equipment.ProcessEquipmentInterface) -> None: ...
    @typing.overload
    def runTransient(self, double: float) -> None: ...
    @typing.overload
    def runTransient(self, double: float, uUID: java.util.UUID) -> None: ...
    @typing.overload
    def run_step(self) -> None: ...
    @typing.overload
    def run_step(self, uUID: java.util.UUID) -> None: ...
    def setController(self, controllerDeviceInterface: jneqsim.neqsim.process.controllerdevice.ControllerDeviceInterface) -> None: ...
    def setDesign(self) -> None: ...
    def setIsCalcDesign(self, boolean: bool) -> None: ...
    def setPreferedThermodynamicModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setProperty(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def setProperty(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    def setRegulatorOutSignal(self, double: float) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def setTemperature(self, double: float) -> None: ...
    def solved(self) -> bool: ...
    @typing.overload
    def toJson(self, reportConfig: jneqsim.neqsim.process.util.report.ReportConfig) -> java.lang.String: ...
    @typing.overload
    def toJson(self) -> java.lang.String: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.processmodel")``.

    ModuleInterface: typing.Type[ModuleInterface]
    ProcessLoader: typing.Type[ProcessLoader]
    ProcessModel: typing.Type[ProcessModel]
    ProcessModule: typing.Type[ProcessModule]
    ProcessModuleBaseClass: typing.Type[ProcessModuleBaseClass]
    ProcessSystem: typing.Type[ProcessSystem]
    processmodules: jneqsim.neqsim.process.processmodel.processmodules.__module_protocol__
