
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jpype
import jneqsim.neqsim.process.equipment
import jneqsim.neqsim.process.equipment.stream
import jneqsim.neqsim.process.processmodel
import typing



class AdsorptionDehydrationlModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.ProcessEquipmentInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...

class CO2RemovalModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...

class DPCUModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def displayResult(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...

class GlycolDehydrationlModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def calcGlycolConcentration(self, double: float) -> float: ...
    def calcKglycol(self) -> float: ...
    def displayResult(self) -> None: ...
    def getFlashPressure(self) -> float: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...
    def setFlashPressure(self, double: float) -> None: ...
    @typing.overload
    def setProperty(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def setProperty(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    def solveAbsorptionFactor(self, double: float) -> float: ...

class MEGReclaimerModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...
    def setOperationPressure(self, double: float) -> None: ...

class MixerGasProcessingModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...

class PropaneCoolingModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setCondenserTemperature(self, double: float) -> None: ...
    def setDesign(self) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def setVaporizerTemperature(self, double: float) -> None: ...

class SeparationTrainModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...

class SeparationTrainModuleSimple(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...

class WellFluidModule(jneqsim.neqsim.process.processmodel.ProcessModuleBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def addInputStream(self, string: typing.Union[java.lang.String, str], streamInterface: jneqsim.neqsim.process.equipment.stream.StreamInterface) -> None: ...
    def calcDesign(self) -> None: ...
    def getOutputStream(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.process.equipment.stream.StreamInterface: ...
    def initializeModule(self) -> None: ...
    def initializeStreams(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def run(self) -> None: ...
    @typing.overload
    def run(self, uUID: java.util.UUID) -> None: ...
    def setDesign(self) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSpecification(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.process.processmodel.processmodules")``.

    AdsorptionDehydrationlModule: typing.Type[AdsorptionDehydrationlModule]
    CO2RemovalModule: typing.Type[CO2RemovalModule]
    DPCUModule: typing.Type[DPCUModule]
    GlycolDehydrationlModule: typing.Type[GlycolDehydrationlModule]
    MEGReclaimerModule: typing.Type[MEGReclaimerModule]
    MixerGasProcessingModule: typing.Type[MixerGasProcessingModule]
    PropaneCoolingModule: typing.Type[PropaneCoolingModule]
    SeparationTrainModule: typing.Type[SeparationTrainModule]
    SeparationTrainModuleSimple: typing.Type[SeparationTrainModuleSimple]
    WellFluidModule: typing.Type[WellFluidModule]
