
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.standards.gasquality
import jneqsim.neqsim.standards.oilquality
import jneqsim.neqsim.standards.salescontract
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.util
import typing



class StandardInterface:
    def calculate(self) -> None: ...
    def createTable(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def display(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getName(self) -> java.lang.String: ...
    def getReferencePressure(self) -> float: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSalesContract(self) -> jneqsim.neqsim.standards.salescontract.ContractInterface: ...
    def getStandardDescription(self) -> java.lang.String: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getUnit(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getValue(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    def isOnSpec(self) -> bool: ...
    def setReferencePressure(self, double: float) -> None: ...
    def setResultTable(self, stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> None: ...
    @typing.overload
    def setSalesContract(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSalesContract(self, contractInterface: jneqsim.neqsim.standards.salescontract.ContractInterface) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...

class Standard(jneqsim.neqsim.util.NamedBaseClass, StandardInterface):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def createTable(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def display(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getReferencePressure(self) -> float: ...
    def getReferenceState(self) -> java.lang.String: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSalesContract(self) -> jneqsim.neqsim.standards.salescontract.ContractInterface: ...
    def getStandardDescription(self) -> java.lang.String: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def setReferencePressure(self, double: float) -> None: ...
    def setReferenceState(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setResultTable(self, stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> None: ...
    @typing.overload
    def setSalesContract(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSalesContract(self, contractInterface: jneqsim.neqsim.standards.salescontract.ContractInterface) -> None: ...
    def setStandardDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThermoSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.standards")``.

    Standard: typing.Type[Standard]
    StandardInterface: typing.Type[StandardInterface]
    gasquality: jneqsim.neqsim.standards.gasquality.__module_protocol__
    oilquality: jneqsim.neqsim.standards.oilquality.__module_protocol__
    salescontract: jneqsim.neqsim.standards.salescontract.__module_protocol__
