
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.standards
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.util
import typing



class ContractInterface:
    def display(self) -> None: ...
    def getContractName(self) -> java.lang.String: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSpecificationsNumber(self) -> int: ...
    def getWaterDewPointSpecPressure(self) -> float: ...
    def getWaterDewPointTemperature(self) -> float: ...
    def prettyPrint(self) -> None: ...
    def runCheck(self) -> None: ...
    def setContract(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setContractName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setResultTable(self, stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> None: ...
    def setSpecificationsNumber(self, int: int) -> None: ...
    def setWaterDewPointSpecPressure(self, double: float) -> None: ...
    def setWaterDewPointTemperature(self, double: float) -> None: ...

class ContractSpecification(jneqsim.neqsim.util.NamedBaseClass):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str], standardInterface: jneqsim.neqsim.standards.StandardInterface, double: float, double2: float, string5: typing.Union[java.lang.String, str], double3: float, double4: float, double5: float, string6: typing.Union[java.lang.String, str]): ...
    def getComments(self) -> java.lang.String: ...
    def getCountry(self) -> java.lang.String: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getReferencePressure(self) -> float: ...
    def getReferenceTemperatureCombustion(self) -> float: ...
    def getReferenceTemperatureMeasurement(self) -> float: ...
    def getSpecification(self) -> java.lang.String: ...
    def getStandard(self) -> jneqsim.neqsim.standards.StandardInterface: ...
    def getTerminal(self) -> java.lang.String: ...
    def getUnit(self) -> java.lang.String: ...
    def setComments(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCountry(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMaxValue(self, double: float) -> None: ...
    def setMinValue(self, double: float) -> None: ...
    def setReferencePressure(self, double: float) -> None: ...
    def setReferenceTemperatureCombustion(self, double: float) -> None: ...
    def setReferenceTemperatureMeasurement(self, double: float) -> None: ...
    def setSpecification(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setStandard(self, standardInterface: jneqsim.neqsim.standards.StandardInterface) -> None: ...
    def setTerminal(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setUnit(self, string: typing.Union[java.lang.String, str]) -> None: ...

class BaseContract(ContractInterface):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    def display(self) -> None: ...
    def getContractName(self) -> java.lang.String: ...
    def getMethod(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.standards.StandardInterface: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSpecification(self, standardInterface: jneqsim.neqsim.standards.StandardInterface, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str], double: float, double2: float, string5: typing.Union[java.lang.String, str], double3: float, double4: float, double5: float, string6: typing.Union[java.lang.String, str]) -> ContractSpecification: ...
    def getSpecificationsNumber(self) -> int: ...
    def getWaterDewPointSpecPressure(self) -> float: ...
    def getWaterDewPointTemperature(self) -> float: ...
    def runCheck(self) -> None: ...
    def setContract(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setContractName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setResultTable(self, stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> None: ...
    def setSpecificationsNumber(self, int: int) -> None: ...
    def setWaterDewPointSpecPressure(self, double: float) -> None: ...
    def setWaterDewPointTemperature(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.standards.salescontract")``.

    BaseContract: typing.Type[BaseContract]
    ContractInterface: typing.Type[ContractInterface]
    ContractSpecification: typing.Type[ContractSpecification]
